/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.ArrayList;
import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectKeyType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.metadata.custom.metadata.assistant.CustomMetadataAssistantService;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedPreference;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedSelectionType;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataPropagationType;
import org.mule.tooling.metadata.datasense.MetadataPair;

public class MetadataActualExpectedParametersContainer {
    private MetadataActualExpectedPreference inputPayloadPreference;
    private MetadataActualExpectedPreference inputAttributesPreference;
    private List<MetadataActualExpectedPreference> inputVariablesPreferences;
    private MetadataActualExpectedPreference outputPayloadPreference;
    private MetadataActualExpectedPreference outputAttributesPreference;
    private List<MetadataActualExpectedPreference> outputVariablesPreferences;
    private MetadataPair<MetadataEvent, MetadataEvent> inputMetadata;
    private MetadataPair<MetadataEvent, MetadataEvent> outputMetadata;

    public MetadataActualExpectedParametersContainer(PropagationInfo propagationInfoInput, PropagationInfo propagationInfoOutput) {
        this.inputMetadata = CustomMetadataAssistantService.getInputMetadataForReferencedFlow(propagationInfoInput);
        this.outputMetadata = CustomMetadataAssistantService.getOutputMetadataForReferencedFlow(propagationInfoOutput);
        this.inputPayloadPreference = this.evaluateExpectedOrActualMetadataInitialPreference(MetadataPropagationType.INPUT_PAYLOAD, this.inputMetadata.getActual().getPayload(), this.inputMetadata.getExpected().getPayload(), MetadataPropagationType.INPUT_PAYLOAD.getMetadataElementName());
        this.inputAttributesPreference = this.evaluateExpectedOrActualMetadataInitialPreference(MetadataPropagationType.INPUT_ATTRIBUTES, this.inputMetadata.getActual().getAttributes(), this.inputMetadata.getExpected().getAttributes(), MetadataPropagationType.INPUT_ATTRIBUTES.getMetadataElementName());
        this.inputVariablesPreferences = this.getVariablesPreferences((MetadataType)this.inputMetadata.getActual().getVariables(), (MetadataType)this.inputMetadata.getExpected().getVariables(), MetadataPropagationType.INPUT_VARIABLE);
        this.outputPayloadPreference = this.evaluateExpectedOrActualMetadataInitialPreference(MetadataPropagationType.OUTPUT_PAYLOAD, this.outputMetadata.getActual().getPayload(), this.outputMetadata.getExpected().getPayload(), MetadataPropagationType.OUTPUT_PAYLOAD.getMetadataElementName());
        this.outputAttributesPreference = this.evaluateExpectedOrActualMetadataInitialPreference(MetadataPropagationType.OUTPUT_ATTRIBUTES, this.outputMetadata.getActual().getAttributes(), this.outputMetadata.getExpected().getAttributes(), MetadataPropagationType.OUTPUT_ATTRIBUTES.getMetadataElementName());
        this.outputVariablesPreferences = this.getVariablesPreferences((MetadataType)this.outputMetadata.getActual().getVariables(), (MetadataType)this.outputMetadata.getExpected().getVariables(), MetadataPropagationType.OUTPUT_VARIABLE);
    }

    private MetadataActualExpectedPreference evaluateExpectedOrActualMetadataInitialPreference(MetadataPropagationType metadataPropagationType, MetadataType actualMetadata, MetadataType expectedMetadata, String elementName) {
        if (CustomMetadataAssistantService.isVariableMetadata(metadataPropagationType) || !CustomMetadataAssistantService.isVariableMetadata(metadataPropagationType) && !expectedMetadata.getMetadataFormat().getId().equals("*") && !actualMetadata.equals(expectedMetadata)) {
            return new MetadataActualExpectedPreference(metadataPropagationType, MetadataActualExpectedSelectionType.EXPECTED, elementName);
        }
        return new MetadataActualExpectedPreference(metadataPropagationType, MetadataActualExpectedSelectionType.ACTUAL, elementName);
    }

    private List<MetadataActualExpectedPreference> getVariablesPreferences(MetadataType actualMetadata, MetadataType expectedMetadata, MetadataPropagationType metadataPropagationType) {
        ArrayList<MetadataActualExpectedPreference> variablesPreferences = new ArrayList<MetadataActualExpectedPreference>();
        ArrayList actualVariables = new ArrayList(((DefaultObjectType)actualMetadata).getFields());
        ArrayList expectedVariables = new ArrayList(((DefaultObjectType)expectedMetadata).getFields());
        ArrayList<ObjectFieldType> allVariables = new ArrayList<ObjectFieldType>();
        allVariables.addAll(actualVariables);
        for (ObjectFieldType expectedVariable : expectedVariables) {
            if (this.hasKey(allVariables, expectedVariable.getKey())) continue;
            allVariables.add(expectedVariable);
        }
        allVariables.forEach(variable -> {
            MetadataType actual = this.getMetadata(actualVariables, variable.getKey());
            MetadataType expected = this.getMetadata(expectedVariables, variable.getKey());
            if (this.metadataExists(actual) && !this.metadataExists(expected)) {
                variablesPreferences.add(new MetadataActualExpectedPreference(metadataPropagationType, MetadataActualExpectedSelectionType.ACTUAL, variable.getKey().getName().toString()));
            } else if (!this.metadataExists(actual) && this.metadataExists(expected)) {
                variablesPreferences.add(new MetadataActualExpectedPreference(metadataPropagationType, MetadataActualExpectedSelectionType.EXPECTED, variable.getKey().getName().toString()));
            } else {
                variablesPreferences.add(this.evaluateExpectedOrActualMetadataInitialPreference(metadataPropagationType, actual, expected, variable.getKey().getName().toString()));
            }
        });
        return variablesPreferences;
    }

    private boolean metadataExists(MetadataType metadata) {
        return metadata != null;
    }

    private boolean hasKey(List<ObjectFieldType> allElements, ObjectKeyType key) {
        for (ObjectFieldType element : allElements) {
            if (!element.getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    private MetadataType getMetadata(List<ObjectFieldType> allElements, ObjectKeyType key) {
        for (ObjectFieldType element : allElements) {
            if (!element.getKey().equals(key)) continue;
            return element;
        }
        return null;
    }

    public MetadataActualExpectedPreference getInputPayloadPreference() {
        return this.inputPayloadPreference;
    }

    public void setInputPayloadPreference(MetadataActualExpectedSelectionType inputPayloadPreference) {
        this.inputPayloadPreference.setMetadataSelectionType(inputPayloadPreference);
    }

    public MetadataActualExpectedPreference getInputAttributesPreference() {
        return this.inputAttributesPreference;
    }

    public void setInputAttributesPreference(MetadataActualExpectedSelectionType inputAttributesPreference) {
        this.inputAttributesPreference.setMetadataSelectionType(inputAttributesPreference);
    }

    public List<MetadataActualExpectedPreference> getInputVariablesPreferences() {
        return this.inputVariablesPreferences;
    }

    public void setInputVariablesPreferences(List<MetadataActualExpectedPreference> inputVariablesPreferences) {
        this.inputVariablesPreferences = inputVariablesPreferences;
    }

    public MetadataActualExpectedPreference getOutputPayloadPreference() {
        return this.outputPayloadPreference;
    }

    public void setOutputPayloadPreference(MetadataActualExpectedSelectionType outputPayloadPreference) {
        this.outputPayloadPreference.setMetadataSelectionType(outputPayloadPreference);
    }

    public MetadataActualExpectedPreference getOutputAttributesPreference() {
        return this.outputAttributesPreference;
    }

    public void setOutputAttributesPreference(MetadataActualExpectedSelectionType outputAttributesPreference) {
        this.outputAttributesPreference.setMetadataSelectionType(outputAttributesPreference);
    }

    public List<MetadataActualExpectedPreference> getOutputVariablesPreferences() {
        return this.outputVariablesPreferences;
    }

    public void setOutputVariablesPreferences(List<MetadataActualExpectedPreference> outputVariablesPreferences) {
        this.outputVariablesPreferences = outputVariablesPreferences;
    }

    public List<MetadataActualExpectedPreference> findMetadataPreference(String rootElementType, String metadataType) {
        List<MetadataActualExpectedPreference> preferences = new ArrayList<MetadataActualExpectedPreference>();
        switch (rootElementType = rootElementType.toUpperCase()) {
            case "VARIABLES": {
                if (metadataType.equalsIgnoreCase("Input")) {
                    preferences = this.getInputVariablesPreferences();
                    break;
                }
                preferences = this.getOutputVariablesPreferences();
                break;
            }
            case "ATTRIBUTES": {
                if (metadataType.equalsIgnoreCase("Input")) {
                    preferences = List.of(this.getInputAttributesPreference());
                    break;
                }
                preferences = List.of(this.getOutputAttributesPreference());
                break;
            }
            case "PAYLOAD": {
                if (metadataType.equalsIgnoreCase("Input")) {
                    preferences = List.of(this.getInputPayloadPreference());
                    break;
                }
                preferences = List.of(this.getOutputPayloadPreference());
                break;
            }
        }
        return preferences;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.inputAttributesPreference == null ? 0 : this.inputAttributesPreference.hashCode());
        result = 31 * result + (this.inputMetadata == null ? 0 : this.inputMetadata.hashCode());
        result = 31 * result + (this.inputPayloadPreference == null ? 0 : this.inputPayloadPreference.hashCode());
        result = 31 * result + (this.inputVariablesPreferences == null ? 0 : this.inputVariablesPreferences.hashCode());
        result = 31 * result + (this.outputAttributesPreference == null ? 0 : this.outputAttributesPreference.hashCode());
        result = 31 * result + (this.outputMetadata == null ? 0 : this.outputMetadata.hashCode());
        result = 31 * result + (this.outputPayloadPreference == null ? 0 : this.outputPayloadPreference.hashCode());
        result = 31 * result + (this.outputVariablesPreferences == null ? 0 : this.outputVariablesPreferences.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetadataActualExpectedParametersContainer other = (MetadataActualExpectedParametersContainer)obj;
        if (this.inputAttributesPreference == null ? other.inputAttributesPreference != null : !this.inputAttributesPreference.equals(other.inputAttributesPreference)) {
            return false;
        }
        if (this.inputMetadata == null ? other.inputMetadata != null : !this.inputMetadata.equals(other.inputMetadata)) {
            return false;
        }
        if (this.inputPayloadPreference == null ? other.inputPayloadPreference != null : !this.inputPayloadPreference.equals(other.inputPayloadPreference)) {
            return false;
        }
        if (this.inputVariablesPreferences == null ? other.inputVariablesPreferences != null : !this.inputVariablesPreferences.equals(other.inputVariablesPreferences)) {
            return false;
        }
        if (this.outputAttributesPreference == null ? other.outputAttributesPreference != null : !this.outputAttributesPreference.equals(other.outputAttributesPreference)) {
            return false;
        }
        if (this.outputMetadata == null ? other.outputMetadata != null : !this.outputMetadata.equals(other.outputMetadata)) {
            return false;
        }
        if (this.outputPayloadPreference == null ? other.outputPayloadPreference != null : !this.outputPayloadPreference.equals(other.outputPayloadPreference)) {
            return false;
        }
        return !(this.outputVariablesPreferences == null ? other.outputVariablesPreferences != null : !this.outputVariablesPreferences.equals(other.outputVariablesPreferences));
    }
}

