/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.HashMap;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;
import org.mule.tooling.metadata.custom.metadata.assistant.WeaveResultHandler;
import org.mule.tooling.metadata.types.utils.DataWeaveMetadataTypeWriter;
import org.mule.tooling.utils.JsonUtils;

public class JsonResultHandler
implements IMetadataResultHandler {
    private IMuleProject project;
    private ITypesManager typesManager;
    private String originDocId;

    public JsonResultHandler(IMuleProject project, ITypesManager typesManager, String originDocId) {
        this.project = project;
        this.typesManager = typesManager;
        this.originDocId = originDocId;
    }

    @Override
    public void generateCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        if (this.isExample(parameters.getMetadata().getAnnotations())) {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateJsonExampleCustomMetadata(parameters.getMetadata(), parameters.getCustomMetadataName()));
        } else if (this.isSchema(parameters.getMetadata().getAnnotations())) {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateJsonSchemaCustomMetadata(parameters.getMetadata()));
        } else {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), new WeaveResultHandler(this.project, this.typesManager, this.originDocId).generateWeaveAsCustomMetadata(parameters.getMetadata(), parameters.getCustomMetadataName(), parameters.getTargetElementDocID(), parameters.getMetadataTypeFormat()));
        }
    }

    private MetadataType generateJsonExampleCustomMetadata(MetadataType metadata, String customMetadataName) {
        HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation> annotations = new HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JSON));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.WEAVE));
        annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(this.getMatchingExistingMetadataLocation(JsonUtils.toJSON((Object)this.getExampleValue(metadata)), "example")));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(new DataWeaveMetadataTypeWriter(customMetadataName).toString(metadata)));
        annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
        return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
    }

    private MetadataType generateJsonSchemaCustomMetadata(MetadataType metadata) {
        HashMap<Class, CustomTypeAnnotation> annotations = new HashMap<Class, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(MetadataTypeFormat.APPLICATION_JSON));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
        annotations.put(PathAnnotation.class, new PathAnnotation(this.getMetadataAdditionalInformation(this.typesManager, IMetadataResultHandler.getCustomMetadataName(metadata), "location")));
        annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
        return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
    }

    @Override
    public String getMatchingExistingMetadataLocation(String jsonExample, String locationKey) {
        return this.typesManager.findCustomMetadataLocationByJsonExample(jsonExample, locationKey);
    }
}

