/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;

public interface IMetadataResultHandler {
    public static final String ERROR_CREATING_RESOURCES_MSG = "Error creating resources";
    public static final String ERROR_CREATING_FOLDER_MSG = "Error creating folder: ";
    public static final String WEAVE_FILE_EXTENSION = ".wev";
    public static final String WEAVE = "weave";
    public static final String EXAMPLE = "example";
    public static final String LOCATION = "location";
    public static final String ELEMENT = "element";
    public static final String FOLDER_SEPARATOR = "/";
    public static final String AUTO_GENERATED_FOLDER = "autogenerated";
    public static final String DOC_ID = "doc:id";
    public static final String DOC_ID_SEPARATOR = "-";
    public static final String AUTO_GENERATED_METADATA_LABEL = "Autogenerated";

    public void generateCustomMetadata(ResultHandlerParameters var1) throws IllegalArgumentException;

    public String getMatchingExistingMetadataLocation(String var1, String var2);

    default public void persistCustomMetadataType(IMuleProject project, String folder, String content, String fileName) {
        try {
            IFolder currentFolder = this.getResourceFolder(project, folder);
            MuleResourceUtils.create((IResource)currentFolder);
            MuleResourceUtils.createFile((IProject)project.getProject(), (IFolder)currentFolder, (String)content, (String)fileName);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)ERROR_CREATING_RESOURCES_MSG, (Throwable)e);
        }
    }

    default public IFolder getResourceFolder(IMuleProject project, String folder) {
        IFolder resourcesFolder = project.getFolder("src/main/resources");
        IFolder currentFolder = resourcesFolder.getFolder(folder);
        if (!currentFolder.getParent().exists()) {
            this.getResourceFolder(project, StringUtils.substringBeforeLast((String)folder, (String)FOLDER_SEPARATOR));
        }
        if (!currentFolder.exists()) {
            try {
                currentFolder.create(false, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)ERROR_CREATING_FOLDER_MSG.concat(folder), (Throwable)e);
            }
        }
        return currentFolder;
    }

    default public void addType(ITypesManager typesManager, String metadataKeyName, MetadataType metadataType) {
        typesManager.addAutogeneratedCustomMetadata(new MetadataKey(metadataKeyName, null, null, null), metadataType);
    }

    default public String getMetadataAdditionalInformation(ITypesManager typesManager, String metadataName, String attribute) {
        return typesManager.getCustomMetadataAdditionalInformation(metadataName, attribute);
    }

    public static String getCustomMetadataName(MetadataType metadata) {
        TypeAliasAnnotation typeAliasAnnotation = (TypeAliasAnnotation)metadata.getAnnotations().stream().filter(TypeAliasAnnotation.class::isInstance).findAny().orElse((TypeAnnotation)new TypeAliasAnnotation(""));
        return typeAliasAnnotation.getValue();
    }

    default public String getExampleValue(MetadataType metadata) {
        ExampleAnnotation exampleAnnotation = (ExampleAnnotation)metadata.getAnnotations().stream().filter(ExampleAnnotation.class::isInstance).findAny().orElse((TypeAnnotation)new ExampleAnnotation(""));
        return exampleAnnotation.getValue();
    }

    default public boolean isExample(Set<TypeAnnotation> annotations) {
        return annotations.stream().anyMatch(ExampleAnnotation.class::isInstance);
    }

    default public boolean isSchema(Set<TypeAnnotation> annotations) {
        return annotations.stream().anyMatch(TypeAliasAnnotation.class::isInstance);
    }

    public static String getFlowNameFromConfig(MuleConfiguration config, String docId) {
        return config.getFlows().stream().filter(value -> {
            if (value.getElement().getAttribute(DOC_ID) != null) {
                return docId.equals(value.getElement().getAttribute(DOC_ID).getText());
            }
            return false;
        }).findAny().map(MessageFlowNode::getName).orElse("");
    }

    public static String getDocId(MetadataKey key) {
        return IMetadataResultHandler.getDocId(key.getId());
    }

    public static String getDocId(String metadataName) {
        return StringUtils.substringBefore((String)StringUtils.substringAfter((String)metadataName, (String)"auto_"), (String)"_");
    }
}

