/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultAnyType;
import org.mule.metadata.api.model.impl.DefaultObjectFieldType;
import org.mule.metadata.api.model.impl.DefaultObjectType;
import org.mule.tooling.client.api.PropagationInfo;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.IMetadataPropagationCache;
import org.mule.tooling.client.metadata.IProjectMetadataManager;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataEvent;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.ProjectMetadataExtensionManager;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataEventEnricher;
import org.mule.tooling.client.metadata.enricher.MetadataTypeRef;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.ToolingJobsManager;
import org.mule.tooling.core.dom.IElementWrapper;
import org.mule.tooling.core.event.SimpleDataSenseSuccessfulCompletionEvent;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.metadata.custom.metadata.assistant.CobolResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.JavaResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.JsonResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedParametersContainer;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedPreference;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataActualExpectedSelectionType;
import org.mule.tooling.metadata.custom.metadata.assistant.MetadataPropagationType;
import org.mule.tooling.metadata.custom.metadata.assistant.RamlResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;
import org.mule.tooling.metadata.custom.metadata.assistant.WeaveResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.XmlResultHandler;
import org.mule.tooling.metadata.datasense.DataSenseJob;
import org.mule.tooling.metadata.datasense.DataSenseRequest;
import org.mule.tooling.metadata.datasense.MetadataPair;
import org.mule.tooling.metadata.datasense.SimpleTypeMetadataTypeUtils;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.utils.eventbus.IEvent;

public class CustomMetadataAssistantService
implements IMuleProjectComponent {
    public static final String CUSTOM_METADATA_NAME_SEPARATOR = "_";
    public static final String CUSTOM_METADATA_VARIABLE_NAME_SEPARATOR = "-";
    private static final String METADATA_TYPE_REF_MODULE = "#Custom Type#";
    public static final String METADATA_FORMAT_UNKNOWN_ID = "*";
    public static final String AUTOGENERATED_METADATA_IDENTIFIER = "auto_";
    public static final String ANY_TYPE = "DefaultAnyType";
    public static final String SCHEMAS_FOLDER = "schemas";
    public static final String EXAMPLES_FOLDER = "examples";
    public static final String WEAVE_FOLDER = "weave";
    public static final String FOLDER_SEPARATOR = "/";
    private static final String METADATA_PROCESS_ERROR_MSG = "It was not possible to process metadata for: ";
    private DataSenseRequest.DataSenseRequestType dataSenseRequestType = DataSenseRequest.DataSenseRequestType.PROPAGATION;
    private ITypesManager typesManager;
    private IMuleProject project;
    private static HashMap<String, MetadataTypeFormat> metadataFormats = new HashMap();

    static {
        metadataFormats.put("java", MetadataTypeFormat.APPLICATION_JAVA);
        metadataFormats.put("json", MetadataTypeFormat.APPLICATION_JSON);
        metadataFormats.put("xml", MetadataTypeFormat.APPLICATION_XML);
        metadataFormats.put("csv", MetadataTypeFormat.APPLICATION_CSV);
        metadataFormats.put("excel", MetadataTypeFormat.APPLICATION_EXCEL);
        metadataFormats.put("copybook", MetadataTypeFormat.APPLICATION_COPYBOOK);
        metadataFormats.put("fixedWidth", MetadataTypeFormat.APPLICATION_FIXED_WIDTH);
        metadataFormats.put("flatfile", MetadataTypeFormat.APPLICATION_FLAT_FILE);
        metadataFormats.put("Weave", MetadataTypeFormat.APPLICATION_WEAVE);
    }

    CustomMetadataAssistantService(IMuleProject project) {
        this.project = project;
        IProjectMetadataManager manager = ProjectMetadataExtensionManager.getInstance().getCurrentIProjectMetadataManager();
        this.typesManager = manager.getTypesManager(project);
    }

    public ITypesManager getDefaultTypesManager() {
        return this.typesManager;
    }

    public DataSenseJob getMetadataPropagationJob(MuleConfiguration muleConfiguration, MulePath mulePath) {
        return this.dispatchDataSenseJob(new DataSenseRequest(this.project, EditingScope.getCurrent(), muleConfiguration, mulePath, this.dataSenseRequestType));
    }

    public static MetadataPair<MetadataEvent, MetadataEvent> getInputMetadataForReferencedFlow(PropagationInfo propagationInfo) {
        MetadataEvent actualInputMetadata = propagationInfo.isFlow() ? propagationInfo.getExpectedMetadataType() : propagationInfo.getIncomingMetadataType();
        MetadataEvent expectedInputMetadata = propagationInfo.isFlow() ? propagationInfo.getInputMetadataType() : propagationInfo.getExpectedInputMetadataType();
        return new MetadataPair<MetadataEvent, MetadataEvent>(actualInputMetadata, expectedInputMetadata);
    }

    public static MetadataPair<MetadataEvent, MetadataEvent> getOutputMetadataForReferencedFlow(PropagationInfo propagationInfo) {
        MetadataEvent actualOutputMetadata = propagationInfo.isFlow() ? propagationInfo.getIncomingMetadataType() : propagationInfo.getResultMetadataType();
        MetadataEvent expectedOutputMetadata = propagationInfo.isFlow() ? propagationInfo.getOutputMetadataType() : propagationInfo.getExpectedMetadataType();
        return new MetadataPair<MetadataEvent, MetadataEvent>(actualOutputMetadata, expectedOutputMetadata);
    }

    private void analizeAndDeleteMetadataInformation(String originFlowRefDocId, String targetFlowDocId, boolean deleteEnrichments) {
        this.deleteAutogeneratedMetadataByFlowRefDocId(originFlowRefDocId);
        if (deleteEnrichments) {
            this.deleteEnrichments(targetFlowDocId);
        }
    }

    public void translatePersistAndAssignMetadata(PropagationInfo propagationInfoFirst, PropagationInfo propagationInfoLast, IElementWrapper originFlowRefElement, MetadataActualExpectedParametersContainer parameters, MessageFlowNode targetNode, boolean deleteEnrichments) {
        IElementWrapper targetFlowElement = targetNode.getElement();
        this.generateDocIDforMissingAttribute(originFlowRefElement);
        this.generateDocIDforMissingAttribute(targetFlowElement);
        String originDocId = originFlowRefElement.getAttributeValue("doc:id");
        String targetDocId = targetFlowElement.getAttributeValue("doc:id");
        this.analizeAndDeleteMetadataInformation(originDocId, targetDocId, deleteEnrichments);
        this.translatePersistAndAssignMetadataAsync(originDocId, targetDocId, CustomMetadataAssistantService.getInputMetadataForReferencedFlow(propagationInfoFirst), CustomMetadataAssistantService.getOutputMetadataForReferencedFlow(propagationInfoLast), parameters, targetNode);
    }

    public void resolveTranslatePersistAndAssignMetadata(DataSenseJob firstElement, DataSenseJob lastElement, IElementWrapper originFlowRefElement, MessageFlowNode targetNode, boolean deleteEnrichments) {
        IElementWrapper targetFlowElement = targetNode.getElement();
        this.generateDocIDforMissingAttribute(originFlowRefElement);
        this.generateDocIDforMissingAttribute(targetFlowElement);
        String originDocId = originFlowRefElement.getAttributeValue("doc:id");
        String targetDocId = targetFlowElement.getAttributeValue("doc:id");
        this.analizeAndDeleteMetadataInformation(originDocId, targetDocId, deleteEnrichments);
        this.resolveCustomMetedataAsync(originDocId, targetDocId, firstElement, lastElement, targetNode);
    }

    private void translatePersistAndAssignMetadataAsync(String originDocId, String targetDocId, MetadataPair<MetadataEvent, MetadataEvent> inputMetadata, MetadataPair<MetadataEvent, MetadataEvent> outputMetadata, MetadataActualExpectedParametersContainer parameters, MessageFlowNode messgeFlowNode) {
        TranslatePersistAndAssignMetadata translatePersistAndAssignMetadata = new TranslatePersistAndAssignMetadata(originDocId, targetDocId, inputMetadata, outputMetadata, parameters, messgeFlowNode);
        translatePersistAndAssignMetadata.setPriority(20);
        translatePersistAndAssignMetadata.schedule();
    }

    private void resolveCustomMetedataAsync(String originDocId, String targetDocId, DataSenseJob firstElement, DataSenseJob lastElement, MessageFlowNode targetNode) {
        ResolveCustomMetedataAsync resolveCustomMetedataAsync = new ResolveCustomMetedataAsync(originDocId, targetDocId, firstElement, lastElement, targetNode);
        resolveCustomMetedataAsync.setPriority(20);
        resolveCustomMetedataAsync.schedule();
    }

    private void persistMetadata() {
        this.typesManager.persist();
    }

    private List<MetadataType> getSelectedVariableMetadata(MetadataType actualMetadata, MetadataType expectedMetadata, List<MetadataActualExpectedPreference> preferences) {
        Collection actualVariables = ((DefaultObjectType)actualMetadata).getFields();
        Collection expectedVariables = ((DefaultObjectType)expectedMetadata).getFields();
        ArrayList<MetadataType> variables = new ArrayList<MetadataType>();
        if (!preferences.isEmpty()) {
            preferences.forEach(preference -> {
                if (preference.getMetadataSelectionType().equals((Object)MetadataActualExpectedSelectionType.ACTUAL)) {
                    this.getVariable(actualVariables, (List<MetadataType>)variables, (MetadataActualExpectedPreference)preference);
                } else if (preference.getMetadataSelectionType().equals((Object)MetadataActualExpectedSelectionType.EXPECTED)) {
                    this.getVariable(expectedVariables, (List<MetadataType>)variables, (MetadataActualExpectedPreference)preference);
                }
            });
        }
        return variables;
    }

    private void getVariable(Collection<ObjectFieldType> actualVariables, List<MetadataType> variables, MetadataActualExpectedPreference preference) {
        actualVariables.forEach(variable -> {
            if (variable.getKey().getName().toString().equals(preference.getElementName())) {
                variables.add((MetadataType)variable);
            }
        });
    }

    private MetadataType getSelectedMetadata(MetadataType actualMetadata, MetadataType expectedMetadata, MetadataActualExpectedPreference preference) {
        if (preference.getMetadataSelectionType().equals((Object)MetadataActualExpectedSelectionType.EXPECTED)) {
            return expectedMetadata;
        }
        if (preference.getMetadataSelectionType().equals((Object)MetadataActualExpectedSelectionType.ACTUAL)) {
            return actualMetadata;
        }
        return null;
    }

    private void deleteEnrichments(String targetFlowDocId) {
        this.typesManager.removeEnricher(ComponentId.fromDocId((String)targetFlowDocId));
    }

    public void deleteAutogeneratedMetadataByFlowRefDocId(String flowRefDocId) {
        this.deleteAutogeneratedMetadataByDocId(flowRefDocId, "");
    }

    public void deleteAutogeneratedMetadataByDocId(String docId, String flowName) {
        this.typesManager.deleteAutogeneratedMetadataByDocId(docId, flowName);
    }

    private String getSimpleTypeMetadataNameByType(String className) {
        MetadataSimpleType[] metadataSimpleTypeArray = MetadataSimpleType.values();
        int n = metadataSimpleTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MetadataSimpleType simpleType = metadataSimpleTypeArray[n2];
            if (simpleType.getClassName().equals(className)) {
                return simpleType.getMetadataName();
            }
            ++n2;
        }
        return "";
    }

    private boolean isSimpleType(String className) {
        return !"".equals(this.getSimpleTypeMetadataNameByType(className));
    }

    private MetadataTypeFormat getMetadataTypeFormat(MetadataType mt) {
        return metadataFormats.get(mt.getMetadataFormat().getId());
    }

    private DataSenseJob dispatchDataSenseJob(DataSenseRequest request) {
        ((IMetadataPropagationCache)MuleCorePlugin.getStudioContext().get(IMetadataPropagationCache.class)).evictProjectPropagation(this.project);
        DataSenseJob dataSenseJob = new DataSenseJob(request);
        dataSenseJob.setJobGroup(ToolingJobsManager.getToolingJobGroup());
        dataSenseJob.setPriority(20);
        dataSenseJob.schedule();
        return dataSenseJob;
    }

    private void processMetadata(MetadataType metadata, String originDocId, String targetElementDocID, MetadataPropagationType metadataPropagationType) {
        if (metadata != null) {
            try {
                if (CustomMetadataAssistantService.isVariableMetadata(metadataPropagationType)) {
                    this.translateGenerateAndAssignMetadata(((ObjectFieldType)metadata).getValue(), this.generateCustomMetadataNameWithVariableName(targetElementDocID, metadataPropagationType.getMetadataCustomTypeName(), ((ObjectFieldType)metadata).getKey().getName().toString()), originDocId, targetElementDocID, metadataPropagationType);
                } else {
                    this.translateGenerateAndAssignMetadata(metadata, this.generateCustomMetadataName(targetElementDocID, metadataPropagationType.getMetadataCustomTypeName()), originDocId, targetElementDocID, metadataPropagationType);
                }
            }
            catch (Exception e) {
                String errorMessage = METADATA_PROCESS_ERROR_MSG.concat(metadataPropagationType.getMetadataCustomTypeName());
                MuleCorePlugin.logError((String)errorMessage, (Throwable)e);
            }
        }
    }

    private String generateCustomMetadataName(String targetElementDocID, String customMetadataDirectionName) {
        return AUTOGENERATED_METADATA_IDENTIFIER.concat(targetElementDocID).concat(CUSTOM_METADATA_NAME_SEPARATOR).concat(customMetadataDirectionName);
    }

    private String generateCustomMetadataNameWithVariableName(String targetElementDocID, String customMetadataDirectionName, String variableName) {
        return this.generateCustomMetadataName(targetElementDocID, customMetadataDirectionName.concat(CUSTOM_METADATA_VARIABLE_NAME_SEPARATOR).concat(variableName));
    }

    public static boolean isVariableMetadata(MetadataPropagationType metadataPropagationType) {
        return metadataPropagationType.equals((Object)MetadataPropagationType.INPUT_VARIABLE) || metadataPropagationType.equals((Object)MetadataPropagationType.OUTPUT_VARIABLE);
    }

    private void translateGenerateAndAssignMetadata(MetadataType metadata, String customMetadataName, String originDocId, String targetElementDocID, MetadataPropagationType metadataPropagationType) throws IllegalArgumentException {
        MetadataTypeFormat metadataTypeFormat = this.getMetadataTypeFormat(metadata);
        String existingCustomMetadataName = IMetadataResultHandler.getCustomMetadataName(metadata);
        if (metadataTypeFormat != null) {
            ResultHandlerParameters parameters = new ResultHandlerParameters(metadata, customMetadataName, originDocId, targetElementDocID, metadataTypeFormat, existingCustomMetadataName);
            switch (metadataTypeFormat) {
                case APPLICATION_JAVA: {
                    if (this.isSimpleType(metadata.getClass().getSimpleName())) {
                        this.generateSimpleMetadata(metadata.getClass().getSimpleName(), customMetadataName, originDocId);
                        break;
                    }
                    if (this.isRAML(existingCustomMetadataName)) {
                        this.generateRamlCustomMetadata(parameters);
                        break;
                    }
                    this.generateJavaCustomMetadata(parameters);
                    break;
                }
                case APPLICATION_FIXED_WIDTH: 
                case APPLICATION_FLAT_FILE: 
                case APPLICATION_COPYBOOK: {
                    this.generateCobolCustomMetadata(parameters);
                    break;
                }
                case APPLICATION_CSV: {
                    if (this.isRAML(existingCustomMetadataName)) {
                        this.generateRamlCustomMetadata(parameters);
                        break;
                    }
                    this.generateWeaveCustomMetadata(parameters);
                    break;
                }
                case APPLICATION_WEAVE: {
                    parameters.setMetadataTypeFormat(MetadataTypeFormat.APPLICATION_JAVA);
                    this.generateWeaveCustomMetadata(parameters);
                    break;
                }
                case APPLICATION_EXCEL: {
                    this.generateWeaveCustomMetadata(parameters);
                    break;
                }
                case APPLICATION_JSON: {
                    this.generateJsonCustomMetadata(parameters);
                    break;
                }
                case APPLICATION_XML: {
                    this.generateXmlCustomMetadata(parameters);
                }
            }
            this.setMetadataToElement(customMetadataName, targetElementDocID, metadataPropagationType);
        }
    }

    private boolean isRAML(String existingCustomMetadataName) {
        return this.typesManager.isCustomMetadataOfMetadataTypeOrigin(existingCustomMetadataName, MetadataTypeOrigin.RAML);
    }

    private boolean isJavaXML(MetadataType metadata) {
        if (metadata instanceof DefaultObjectType) {
            return ((DefaultObjectType)metadata).getFields().stream().filter(DefaultObjectFieldType.class::isInstance).findFirst().map(entry -> entry.getValue().toString().contains("#root:")).orElse(false);
        }
        return false;
    }

    private void generateCobolCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        new CobolResultHandler(this.project, this.typesManager, parameters.getOriginDocID()).generateCustomMetadata(parameters);
    }

    private void generateJavaCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        if (!parameters.getMetadata().getAnnotations().isEmpty() && !parameters.getMetadata().getClass().equals(DefaultAnyType.class)) {
            new JavaResultHandler(this.project, this.typesManager, parameters.getOriginDocID()).generateCustomMetadata(parameters);
        } else if (this.isJavaXML(parameters.getMetadata())) {
            this.generateXmlCustomMetadata(parameters);
        } else {
            this.generateWeaveCustomMetadata(parameters);
        }
    }

    private void generateRamlCustomMetadata(ResultHandlerParameters parameters) {
        new RamlResultHandler(this.typesManager, parameters.getOriginDocID()).generateCustomMetadata(parameters);
    }

    private void generateWeaveCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        new WeaveResultHandler(this.project, this.typesManager, parameters.getOriginDocID()).generateCustomMetadata(parameters);
    }

    private void generateJsonCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        new JsonResultHandler(this.project, this.typesManager, parameters.getOriginDocID()).generateCustomMetadata(parameters);
    }

    private void generateXmlCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        new XmlResultHandler(this.project, this.typesManager, parameters.getOriginDocID()).generateCustomMetadata(parameters);
    }

    private void addType(String metadataKeyName, MetadataType metadataType) {
        this.typesManager.addAutogeneratedCustomMetadata(new MetadataKey(metadataKeyName, null, null, null), metadataType);
    }

    private void generateSimpleMetadata(String metadataClassSimpleName, String customMetadataName, String originDocId) {
        this.addType(customMetadataName, SimpleTypeMetadataTypeUtils.buildSimpleType(this.getSimpleTypeMetadataNameByType(metadataClassSimpleName), originDocId));
    }

    private MetadataTypeRef generateMetadataReference(String metadataName) {
        return MetadataTypeRef.builder().withModule(METADATA_TYPE_REF_MODULE).withKey(metadataName).build();
    }

    private boolean hasCustomMetadata(String targetElementDocId) {
        return this.typesManager.getEnricher(ComponentId.fromDocId((String)targetElementDocId)).isPresent();
    }

    private void setMetadataToElement(String customMetadataName, String targetElementDocID, MetadataPropagationType metadataPropagationType) {
        MetadataTypeRef metadataTypeRef = this.generateMetadataReference(customMetadataName);
        ComponentId componentId = ComponentId.fromDocId((String)targetElementDocID);
        MetadataEnricher metadataEnricher = this.typesManager.getEnricher(componentId).orElse(new MetadataEnricher(componentId));
        MetadataEventEnricher inputEnricher = metadataEnricher.getInputEnricher().orElse(new MetadataEventEnricher());
        MetadataEventEnricher outputEnricher = metadataEnricher.getOutputEnricher().orElse(new MetadataEventEnricher());
        switch (metadataPropagationType) {
            case INPUT_PAYLOAD: {
                inputEnricher.setPayload(metadataTypeRef);
                break;
            }
            case OUTPUT_PAYLOAD: {
                outputEnricher.setPayload(metadataTypeRef);
                break;
            }
            case INPUT_ATTRIBUTES: {
                inputEnricher.setAttributes(metadataTypeRef);
                break;
            }
            case OUTPUT_ATTRIBUTES: {
                outputEnricher.setAttributes(metadataTypeRef);
                break;
            }
            case INPUT_VARIABLE: {
                inputEnricher.getVariables().put(this.getVariableNameFromCustomMetadataName(customMetadataName), metadataTypeRef);
                break;
            }
            case OUTPUT_VARIABLE: {
                outputEnricher.getVariables().put(this.getVariableNameFromCustomMetadataName(customMetadataName), metadataTypeRef);
            }
        }
        this.typesManager.enrich(metadataEnricher);
    }

    private String getVariableNameFromCustomMetadataName(String customMetadataName) {
        return StringUtils.substringAfterLast((String)customMetadataName, (String)CUSTOM_METADATA_VARIABLE_NAME_SEPARATOR);
    }

    public MetadataActualExpectedParametersContainer getActualExpectedMetadataParametersContainer(PropagationInfo propagationInfoFirstElement, PropagationInfo propagationInfoLastElement) {
        return new MetadataActualExpectedParametersContainer(propagationInfoFirstElement, propagationInfoLastElement);
    }

    private void generateDocIDforMissingAttribute(IElementWrapper element) {
        if (this.isDocIdMissing(element)) {
            element.addAttribute("doc:id", UUID.randomUUID().toString());
        }
    }

    public boolean isDocIdMissing(IElementWrapper element) {
        return element.getAttribute("doc:id") == null || StringUtils.isEmpty((CharSequence)element.getAttributeValue("doc:id"));
    }

    public static enum MetadataSimpleType {
        STRING("DefaultStringType", "string"),
        NUMBER("DefaultNumberType", "number"),
        INTEGER("DefaultIntegerType", "integer"),
        BOOLEAN("DefaultBooleanType", "boolean"),
        DATE("DefaultDateType", "date-only"),
        DATETIME("DefaultDateTimeType", "datetime");

        private final String className;
        private final String metadataName;

        private MetadataSimpleType(String className, String metadataName) {
            this.className = className;
            this.metadataName = metadataName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMetadataName() {
            return this.metadataName;
        }
    }

    private final class ResolveCustomMetedataAsync
    extends Job {
        String originDocId;
        String targetDocId;
        DataSenseJob firstElement;
        DataSenseJob lastElement;
        MessageFlowNode targetNode;

        public ResolveCustomMetedataAsync(String originDocId, String targetDocId, DataSenseJob firstElement, DataSenseJob lastElement, MessageFlowNode targetNode) {
            super("Resolve Flow Reference Custom Metadata");
            this.originDocId = originDocId;
            this.targetDocId = targetDocId;
            this.firstElement = firstElement;
            this.lastElement = lastElement;
            this.targetNode = targetNode;
        }

        protected IStatus run(IProgressMonitor monitor) {
            PropagationInfo firstPropationInfo = this.firstElement.joinAndGetPropagationInfo();
            PropagationInfo lastPropationInfo = this.lastElement.joinAndGetPropagationInfo();
            CustomMetadataAssistantService.this.translatePersistAndAssignMetadataAsync(this.originDocId, this.targetDocId, CustomMetadataAssistantService.getInputMetadataForReferencedFlow(firstPropationInfo), CustomMetadataAssistantService.getOutputMetadataForReferencedFlow(lastPropationInfo), CustomMetadataAssistantService.this.getActualExpectedMetadataParametersContainer(firstPropationInfo, lastPropationInfo), this.targetNode);
            return Status.OK_STATUS;
        }
    }

    private final class TranslatePersistAndAssignMetadata
    extends Job {
        String originDocId;
        String targetDocId;
        MetadataPair<MetadataEvent, MetadataEvent> inputMetadata;
        MetadataPair<MetadataEvent, MetadataEvent> outputMetadata;
        MetadataActualExpectedParametersContainer parameters;
        MessageFlowNode targetNode;

        public TranslatePersistAndAssignMetadata(String originDocId, String targetDocId, MetadataPair<MetadataEvent, MetadataEvent> inputMetadata, MetadataPair<MetadataEvent, MetadataEvent> outputMetadata, MetadataActualExpectedParametersContainer parameters, MessageFlowNode targetNode) {
            super("Persist Custom Metadata");
            this.originDocId = originDocId;
            this.targetDocId = targetDocId;
            this.inputMetadata = inputMetadata;
            this.outputMetadata = outputMetadata;
            this.parameters = parameters;
            this.targetNode = targetNode;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!CustomMetadataAssistantService.this.hasCustomMetadata(this.targetDocId)) {
                MetadataEvent inputActual = this.inputMetadata.getActual();
                MetadataEvent inputExpected = this.inputMetadata.getExpected();
                MetadataType inputPayload = CustomMetadataAssistantService.this.getSelectedMetadata(inputActual.getPayload(), inputExpected.getPayload(), this.parameters.getInputPayloadPreference());
                MetadataType inputAttributes = CustomMetadataAssistantService.this.getSelectedMetadata(inputActual.getAttributes(), inputExpected.getAttributes(), this.parameters.getInputAttributesPreference());
                List<MetadataType> inputVariables = CustomMetadataAssistantService.this.getSelectedVariableMetadata((MetadataType)inputActual.getVariables(), (MetadataType)inputExpected.getVariables(), this.parameters.getInputVariablesPreferences());
                CustomMetadataAssistantService.this.processMetadata(inputPayload, this.originDocId, this.targetDocId, MetadataPropagationType.INPUT_PAYLOAD);
                CustomMetadataAssistantService.this.processMetadata(inputAttributes, this.originDocId, this.targetDocId, MetadataPropagationType.INPUT_ATTRIBUTES);
                inputVariables.forEach(inputVar -> CustomMetadataAssistantService.this.processMetadata((MetadataType)inputVar, this.originDocId, this.targetDocId, MetadataPropagationType.INPUT_VARIABLE));
                MetadataEvent outputActual = this.outputMetadata.getActual();
                MetadataEvent outputExpected = this.outputMetadata.getExpected();
                MetadataType outputPayload = CustomMetadataAssistantService.this.getSelectedMetadata(outputActual.getPayload(), outputExpected.getPayload(), this.parameters.getOutputPayloadPreference());
                MetadataType outputAttributes = CustomMetadataAssistantService.this.getSelectedMetadata(outputActual.getAttributes(), outputExpected.getAttributes(), this.parameters.getOutputAttributesPreference());
                List<MetadataType> outputVariables = CustomMetadataAssistantService.this.getSelectedVariableMetadata((MetadataType)outputActual.getVariables(), (MetadataType)outputExpected.getVariables(), this.parameters.getOutputVariablesPreferences());
                CustomMetadataAssistantService.this.processMetadata(outputPayload, this.originDocId, this.targetDocId, MetadataPropagationType.OUTPUT_PAYLOAD);
                CustomMetadataAssistantService.this.processMetadata(outputAttributes, this.originDocId, this.targetDocId, MetadataPropagationType.OUTPUT_ATTRIBUTES);
                outputVariables.forEach(ouputVar -> CustomMetadataAssistantService.this.processMetadata((MetadataType)ouputVar, this.originDocId, this.targetDocId, MetadataPropagationType.OUTPUT_VARIABLE));
                CustomMetadataAssistantService.this.persistMetadata();
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new SimpleDataSenseSuccessfulCompletionEvent(CustomMetadataAssistantService.this.project, this.targetNode));
            }
            return Status.OK_STATUS;
        }
    }
}

