/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.custom.metadata.assistant;

import java.util.HashMap;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.annotations.AutogeneratedAnnotation;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.annotations.CustomTypeAnnotation;
import org.mule.tooling.metadata.annotations.ElementAnnotation;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.annotations.FormatAnnotation;
import org.mule.tooling.metadata.annotations.OriginAnnotation;
import org.mule.tooling.metadata.annotations.PathAnnotation;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.ResultHandlerParameters;
import org.mule.tooling.metadata.custom.metadata.assistant.WeaveResultHandler;

public class CobolResultHandler
implements IMetadataResultHandler {
    private IMuleProject project;
    private ITypesManager typesManager;
    private String originDocId;

    public CobolResultHandler(IMuleProject project, ITypesManager typesManager, String originDocId) {
        this.project = project;
        this.typesManager = typesManager;
        this.originDocId = originDocId;
    }

    @Override
    public void generateCustomMetadata(ResultHandlerParameters parameters) throws IllegalArgumentException {
        if (!parameters.getMetadata().getAnnotations().isEmpty()) {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), this.generateCobolAsCustomMetadata(parameters.getMetadata(), parameters.getMetadataTypeFormat(), parameters.getExistingMetadataName()));
        } else {
            this.addType(this.typesManager, parameters.getCustomMetadataName(), new WeaveResultHandler(this.project, this.typesManager, this.originDocId).generateWeaveAsCustomMetadata(parameters.getMetadata(), parameters.getCustomMetadataName(), parameters.getTargetElementDocID(), parameters.getMetadataTypeFormat()));
        }
    }

    private MetadataType generateCobolAsCustomMetadata(MetadataType metadata, MetadataTypeFormat metadataTypeFormat, String existingMetadataName) {
        HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation> annotations = new HashMap<Class<AutogeneratedAnnotation>, CustomTypeAnnotation>();
        annotations.put(FormatAnnotation.class, new FormatAnnotation(metadataTypeFormat));
        annotations.put(OriginAnnotation.class, new OriginAnnotation(MetadataTypeOrigin.SCHEMA));
        annotations.put(ElementAnnotation.class, new ElementAnnotation(this.getMatchingExistingMetadataLocation(existingMetadataName, "element")));
        annotations.put(PathAnnotation.class, new PathAnnotation(this.getMatchingExistingMetadataLocation(existingMetadataName, "location")));
        annotations.put(ExamplePathAnnotation.class, new ExamplePathAnnotation(this.getMatchingExistingMetadataLocation(existingMetadataName, "example")));
        annotations.put(ContentAnnotation.class, new ContentAnnotation(this.typesManager.findCustomMetadataContentByMetadataName(existingMetadataName)));
        annotations.put(AutogeneratedAnnotation.class, new AutogeneratedAnnotation(this.originDocId));
        return MetadataTypeProxy.proxying((MetadataType)metadata, annotations);
    }

    @Override
    public String getMatchingExistingMetadataLocation(String existingMetadataName, String locationKey) {
        return this.typesManager.findCustomMetadataLocationByMetadataName(existingMetadataName, locationKey);
    }
}

