/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.cache;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.metadata.UpdateMetadataListener;
import org.mule.tooling.metadata.annotations.ExamplePathAnnotation;
import org.mule.tooling.metadata.custom.metadata.assistant.IMetadataResultHandler;
import org.mule.tooling.metadata.custom.metadata.assistant.WeaveResultHandler;
import org.mule.tooling.metadata.types.converters.IMetadataTypeConverter;
import org.mule.tooling.metadata.types.converters.MetadataTypeConverters;
import org.mule.tooling.metadata.types.helper.CustomMetadataDefinitionHelper;
import org.mule.tooling.metadata.types.model.MetadataTypeDefinition;
import org.mule.tooling.metadata.types.repository.DefaultTypesRepository;
import org.mule.tooling.metadata.types.repository.ITypesRepository;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.utils.LazyValue;

public class DefaultTypesManager
implements ITypesManager {
    private static final String FOLDER_SEPARATOR = "/";
    private static final String ERROR_DELETING_AUTOGENERATED_METADATA = "It was not possible to delete autogenerated metadata";
    private static final String EXAMPLE = "example";
    private IMuleProject project;
    private final Map<String, Map<String, ITypesRepository>> typesRepository;
    private final CustomMetadataDefinitionHelper customMetadataDefinitionHelper;
    private LazyValue<UpdateMetadataListener> updateMetadataListener;
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private volatile boolean initialized;

    public DefaultTypesManager(IMuleProject project) {
        this.project = project;
        this.typesRepository = new HashMap<String, Map<String, ITypesRepository>>();
        this.customMetadataDefinitionHelper = new CustomMetadataDefinitionHelper(project);
        this.updateMetadataListener = new LazyValue(() -> new UpdateMetadataListener(this, project.getProject()));
    }

    public void reload() {
        this.writeLock.lock();
        try {
            this.customMetadataDefinitionHelper.reload();
            this.initializeTypeRepository();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.typesRepository.entrySet().stream().flatMap(x -> ((Map)x.getValue()).entrySet().stream()).mapToInt(e -> ((ITypesRepository)e.getValue()).getMetadataKeys().size()).sum() == 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean hasMetadataKey(String module, String category, MetadataKey key) {
        this.readLock.lock();
        try {
            boolean bl = this.getModulesTypesRepositories(module).flatMap(mm -> this.getCategoryTypesRepositoryFor(category, (Map<String, ITypesRepository>)mm)).map(r -> r.hasMetadataKey(key)).orElse(false);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setMetadataKeys(String module, String category, Set<MetadataKey> keys) {
        this.writeLock.lock();
        try {
            this.doSetMetadataKeys(module, category, keys);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public MetadataType getMetadataType(String module, String category, MetadataKey key) {
        this.readLock.lock();
        try {
            MetadataType metadataType = this.getModulesTypesRepositories(module).flatMap(mm -> this.getCategoryTypesRepositoryFor(category, (Map<String, ITypesRepository>)mm)).map(r -> r.getMetadataType(key)).orElse(null);
            return metadataType;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public MetadataKey getMetadataKeyByName(String module, String category, String keyName) {
        this.initializeTypeRepositoryIfRequired();
        this.readLock.lock();
        try {
            ITypesRepository repository = this.getModulesTypesRepositories(module).flatMap(mm -> this.getCategoryTypesRepositoryFor(category, (Map<String, ITypesRepository>)mm)).orElse(null);
            if (repository != null) {
                for (MetadataKey key : repository.getMetadataKeys()) {
                    if (!key.getId().equals(keyName)) continue;
                    MetadataKey metadataKey = key;
                    return metadataKey;
                }
            }
            return null;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<MetadataKey> getCustomMetadataKeys() {
        this.initializeTypeRepositoryIfRequired();
        this.readLock.lock();
        try {
            Set<MetadataKey> set = this.getCustomTypesRepository().getMetadataKeys();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Map<String, Set<MetadataKey>> getMetadataKeys(String module) {
        this.readLock.lock();
        try {
            Map<String, ITypesRepository> repository = this.typesRepository.get(module);
            if (repository == null) {
                Map<String, Set<MetadataKey>> map = Collections.emptyMap();
                return map;
            }
            Map<String, Set<MetadataKey>> map = repository.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ITypesRepository)e.getValue()).getMetadataKeys()));
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addCustomMetadata(MetadataKey key, MetadataType structure) {
        this.initializeTypeRepositoryIfRequired();
        this.writeLock.lock();
        try {
            this.getCustomTypesRepository().addMetadataType(key, structure);
            this.customMetadataDefinitionHelper.addType(key, structure);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void addAutogeneratedCustomMetadata(MetadataKey key, MetadataType structure) {
        this.writeLock.lock();
        try {
            this.customMetadataDefinitionHelper.addType(key, structure);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public MetadataType getCustomMetadataType(MetadataKey key) {
        this.initializeTypeRepositoryIfRequired();
        this.readLock.lock();
        try {
            MetadataType metadataType = this.getCustomTypesRepository().getMetadataType(key);
            return metadataType;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void removeCustomMetadata(MetadataKey key) {
        this.initializeTypeRepositoryIfRequired();
        this.writeLock.lock();
        try {
            Optional annotation = this.getCustomTypesRepository().getMetadataType(key).getAnnotation(ExamplePathAnnotation.class);
            if (annotation.isPresent() && ((ExamplePathAnnotation)annotation.get()).getPath().endsWith("json")) {
                ((UpdateMetadataListener)this.updateMetadataListener.getOrCompute()).removeCustomType(((ExamplePathAnnotation)annotation.get()).getPath(), key.getId());
            }
            this.getCustomTypesRepository().removeMetadataType(key);
            this.customMetadataDefinitionHelper.removeType(key);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getCustomMetadataAdditionalInformation(String metadataName, String attribute) {
        this.readLock.lock();
        try {
            String string = this.customMetadataDefinitionHelper.getDefaultCatalog().get(metadataName).getAdditionalInformation().get(attribute);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public MetadataTypeFormat getAutogeneratedCustomMetadataFormat(String metadataName) {
        this.readLock.lock();
        try {
            MetadataTypeFormat metadataTypeFormat = this.customMetadataDefinitionHelper.getDefaultCatalog().get(metadataName).getFormat();
            return metadataTypeFormat;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String findCustomMetadataContentByMetadataName(String existingMetadataName) {
        Predicate<Map.Entry<String, MetadataTypeDefinition>> filter = entry -> ((MetadataTypeDefinition)entry.getValue()).getName().equals(existingMetadataName);
        Function<Map.Entry<String, MetadataTypeDefinition>, String> map = entry -> ((MetadataTypeDefinition)entry.getValue()).getContent();
        return this.findCustomMetadataLocationBy(filter, map);
    }

    public String findCustomMetadataLocationByMetadataName(String existingMetadataName, String locationKey) {
        Predicate<Map.Entry<String, MetadataTypeDefinition>> filter = entry -> ((MetadataTypeDefinition)entry.getValue()).getName().equals(existingMetadataName);
        Function<Map.Entry<String, MetadataTypeDefinition>, String> map = entry -> ((MetadataTypeDefinition)entry.getValue()).getAdditionalInformation().get(locationKey);
        return this.findCustomMetadataLocationBy(filter, map);
    }

    public String findCustomMetadataLocationByJsonExample(String jsonExample, String locationKey) {
        Predicate<Map.Entry<String, MetadataTypeDefinition>> filter = entry -> this.isMatchingJsonExample((Map.Entry<String, MetadataTypeDefinition>)entry, jsonExample);
        Function<Map.Entry<String, MetadataTypeDefinition>, String> map = entry -> ((MetadataTypeDefinition)entry.getValue()).getAdditionalInformation().get(locationKey);
        return this.findCustomMetadataLocationBy(filter, map);
    }

    public String findCustomMetadataLocationByMetadataFormat(String content, String variableName, String locationKey, MetadataTypeFormat metadataTypeFormat) {
        Predicate<Map.Entry<String, MetadataTypeDefinition>> filter = entry -> ((MetadataTypeDefinition)entry.getValue()).getFormat().equals((Object)metadataTypeFormat) && ((MetadataTypeDefinition)entry.getValue()).getContent() != null && ((MetadataTypeDefinition)entry.getValue()).getContent().equals(content.replace(variableName, ((MetadataTypeDefinition)entry.getValue()).getName()));
        Function<Map.Entry<String, MetadataTypeDefinition>, String> map = entry -> ((MetadataTypeDefinition)entry.getValue()).getAdditionalInformation().get(locationKey);
        return this.findCustomMetadataLocationBy(filter, map);
    }

    private String findCustomMetadataLocationBy(Predicate<Map.Entry<String, MetadataTypeDefinition>> filter, Function<Map.Entry<String, MetadataTypeDefinition>, String> map) {
        this.readLock.lock();
        try {
            String string = this.customMetadataDefinitionHelper.getDefaultCatalog().entrySet().stream().filter(filter).findAny().map(map).orElse("");
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isMatchingJsonExample(Map.Entry<String, MetadataTypeDefinition> entry, String jsonExample) {
        MetadataTypeDefinition mtd = entry.getValue();
        return mtd.getFormat().equals((Object)MetadataTypeFormat.APPLICATION_JSON) && mtd.getAdditionalInformation().containsKey(EXAMPLE) && mtd.getContent().contains(jsonExample);
    }

    public boolean isCustomMetadataOfMetadataTypeOrigin(String existingCustomMetadataName, MetadataTypeOrigin metadataTypeOrigin) {
        this.readLock.lock();
        try {
            MetadataTypeDefinition mtd = this.customMetadataDefinitionHelper.getDefaultCatalog().get(existingCustomMetadataName);
            if (mtd != null) {
                boolean bl = metadataTypeOrigin.equals((Object)mtd.getOrigin());
                return bl;
            }
            return false;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void deleteAutogeneratedMetadataByDocId(String docId, String flowName) {
        this.writeLock.lock();
        this.cleanUselessReferences();
        try {
            if (!StringUtils.isEmpty((CharSequence)docId)) {
                HashSet<IFolder> autogeneratedFoldersToDelete = new HashSet<IFolder>();
                this.customMetadataDefinitionHelper.getDefaultCatalog().entrySet().stream().filter(item -> this.shouldDeleteMetadata((String)item.getKey(), ((MetadataTypeDefinition)item.getValue()).getAdditionalInformation(), docId)).collect(Collectors.toList()).forEach(metadataItem -> {
                    this.customMetadataDefinitionHelper.removeType((String)metadataItem.getKey());
                    autogeneratedFoldersToDelete.add(this.getAutogeneratedMetadataFolderPath((String)metadataItem.getKey()));
                });
                if (!StringUtils.isEmpty((CharSequence)flowName)) {
                    this.removeMetadataGeneratedByChildFlowRefsOfFlowBeingRemoved(autogeneratedFoldersToDelete);
                }
                this.customMetadataDefinitionHelper.persist();
                autogeneratedFoldersToDelete.forEach(folder -> this.deleteAutogeneratedMetadataFolder((IFolder)folder));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void cleanUselessReferences() {
        try {
            IFolder autogeneratedMetadataFolder = this.project.getFolder(WeaveResultHandler.FULL_WEAVE_FOLDER_PATH);
            if (autogeneratedMetadataFolder.exists()) {
                Set<Map.Entry<String, MetadataTypeDefinition>> metadatas = this.customMetadataDefinitionHelper.getDefaultCatalog().entrySet();
                IResource[] iResourceArray = autogeneratedMetadataFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource folder = iResourceArray[n2];
                    if (metadatas.stream().noneMatch(metadata -> ((String)metadata.getKey()).startsWith("auto_".concat(folder.getName())))) {
                        this.deleteAutogeneratedMetadataFolder((IFolder)folder);
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)ERROR_DELETING_AUTOGENERATED_METADATA, (Throwable)e);
        }
    }

    private void deleteAutogeneratedMetadataFolder(IFolder autogeneratedMetadataFolder) {
        try {
            autogeneratedMetadataFolder.delete(4, null);
            autogeneratedMetadataFolder.getProject().refreshLocal(2, null);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError((String)ERROR_DELETING_AUTOGENERATED_METADATA, (Throwable)e);
        }
    }

    private void removeMetadataGeneratedByChildFlowRefsOfFlowBeingRemoved(Set<IFolder> autogeneratedFoldersToDelete) {
        List flowRefs = this.project.getConfigurationsCache().getAllFlowReferences();
        HashMap<String, String> autogeneratedMetadatas = this.getAutoGeneratedCustomMetadatas();
        autogeneratedMetadatas.entrySet().forEach(metadata -> {
            String docId = (String)metadata.getValue();
            String key = (String)metadata.getKey();
            if (flowRefs.stream().noneMatch(flowRef -> flowRef.getElement().getAttribute("doc:id").getText().equals(docId))) {
                this.customMetadataDefinitionHelper.removeType(key);
                autogeneratedFoldersToDelete.add(this.getAutogeneratedMetadataFolderPath(key));
            }
        });
    }

    private HashMap<String, String> getAutoGeneratedCustomMetadatas() {
        this.writeLock.lock();
        try {
            HashMap<String, String> autogeneratedMetadatas = new HashMap<String, String>();
            this.customMetadataDefinitionHelper.getDefaultCatalog().entrySet().stream().filter(metadata -> ((MetadataTypeDefinition)metadata.getValue()).getAdditionalInformation().containsKey("autogeneratedOrigin")).forEach(metadata -> {
                String string = autogeneratedMetadatas.put((String)metadata.getKey(), ((MetadataTypeDefinition)metadata.getValue()).getAdditionalInformation().get("autogeneratedOrigin"));
            });
            HashMap<String, String> hashMap = autogeneratedMetadatas;
            return hashMap;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private IFolder getAutogeneratedMetadataFolderPath(String docID) {
        return this.project.getFolder(WeaveResultHandler.FULL_WEAVE_FOLDER_PATH.concat(FOLDER_SEPARATOR).concat(IMetadataResultHandler.getDocId(docID)));
    }

    private boolean shouldDeleteMetadata(String key, Map<String, String> additionalInformation, String docId) {
        return key.startsWith("auto_".concat(docId)) || additionalInformation.keySet().stream().anyMatch(item -> item.equals("autogeneratedOrigin") && ((String)additionalInformation.get(item)).equals(docId));
    }

    public void removeMetadataType(String module, String category, MetadataKey key) {
        this.writeLock.lock();
        try {
            this.getModulesTypesRepositories(module).ifPresent(x -> this.getCategoryTypesRepositoryFor(category, (Map<String, ITypesRepository>)x).ifPresent(repo -> repo.removeMetadataType(key)));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeMetadataTypes(String module) {
        this.writeLock.lock();
        try {
            this.typesRepository.remove(module);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void persistCustomTypes() {
        this.writeLock.lock();
        try {
            this.customMetadataDefinitionHelper.persistCustomTypes();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void persist() {
        this.writeLock.lock();
        try {
            this.customMetadataDefinitionHelper.persist();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearCustomTypes() {
        this.writeLock.lock();
        try {
            this.initializeCustomTypes();
            this.customMetadataDefinitionHelper.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void clearTypes(boolean deleteCustomTypes) {
        this.initializeTypeRepositoryIfRequired();
        this.writeLock.lock();
        try {
            ITypesRepository customTypeRepository = this.getCustomTypesRepository();
            this.typesRepository.clear();
            if (deleteCustomTypes) {
                this.customMetadataDefinitionHelper.clear();
                this.initializeCustomTypes();
            } else {
                this.doSetMetadataKeys("#Custom Type#", "#Default Category#", customTypeRepository.getMetadataKeys());
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void enrich(MetadataEnricher enricher) {
        this.writeLock.lock();
        try {
            this.customMetadataDefinitionHelper.enrich(enricher);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeEnricher(ComponentId componentId) {
        this.writeLock.lock();
        try {
            this.customMetadataDefinitionHelper.removeEnricher(componentId);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Optional<MetadataEnricher> getEnricher(ComponentId componentId) {
        this.readLock.lock();
        try {
            Optional<MetadataEnricher> optional = this.customMetadataDefinitionHelper.getEnricher(componentId);
            return optional;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTypeRepositoryIfRequired() {
        if (!this.initialized) {
            DefaultTypesManager defaultTypesManager = this;
            synchronized (defaultTypesManager) {
                if (!this.initialized) {
                    this.initializeTypeRepository();
                }
            }
        }
    }

    private void initializeTypeRepository() {
        this.writeLock.lock();
        try {
            this.initializeCustomTypes();
            ITypesRepository customTypesRepository = this.getCustomTypesRepository();
            Map<String, MetadataTypeDefinition> defaultCatalog = this.customMetadataDefinitionHelper.getDefaultCatalog();
            for (Map.Entry<String, MetadataTypeDefinition> entry : defaultCatalog.entrySet()) {
                MetadataKey key = ToolingMetadataKeyBuilder.newKey((String)entry.getKey()).build();
                MetadataTypeDefinition metadataTypeDefinition = entry.getValue();
                MetadataTypeFormat format = metadataTypeDefinition.getFormat();
                MetadataTypeOrigin origin = metadataTypeDefinition.getOrigin();
                Optional<IMetadataTypeConverter> maybeConverter = MetadataTypeConverters.getConverter(format, origin);
                try {
                    customTypesRepository.addMetadataType(key, maybeConverter.orElseThrow(() -> new RuntimeException(MessageFormat.format("Converter not found for ({0},{1})", format, origin))).toMetadataType(this.project, metadataTypeDefinition));
                }
                catch (Exception e) {
                    MuleCorePlugin.logError((String)"Error converting definition to metadata type", (Throwable)e);
                }
            }
        }
        finally {
            this.initialized = true;
            this.writeLock.unlock();
        }
    }

    public Set<MetadataKey> getMetadataKeys(String module, String category) {
        this.writeLock.lock();
        try {
            Optional<Map<String, ITypesRepository>> typesRepositoryFor = this.getModulesTypesRepositories(module);
            if (typesRepositoryFor.isPresent()) {
                Map<String, ITypesRepository> repositoryByCategory = typesRepositoryFor.get();
                Optional<ITypesRepository> categoryTypesRepositoryFor = this.getCategoryTypesRepositoryFor(category, repositoryByCategory);
                if (categoryTypesRepositoryFor.isPresent()) {
                    Set<MetadataKey> set = categoryTypesRepositoryFor.get().getMetadataKeys();
                    return set;
                }
                if (!repositoryByCategory.isEmpty() && "#Default Category#".equals(category)) {
                    Set<MetadataKey> set = repositoryByCategory.values().stream().flatMap(x -> x.getMetadataKeys().stream()).collect(Collectors.toSet());
                    return set;
                }
            }
            Set<MetadataKey> set = Collections.emptySet();
            return set;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void doSetMetadataKeys(String module, String category, Set<MetadataKey> keys) {
        Map repository = this.typesRepository.computeIfAbsent(module, mod -> new HashMap());
        HashMap<MetadataKey, MetadataType> newTypes = new HashMap<MetadataKey, MetadataType>();
        ITypesRepository typeRepository = repository.computeIfAbsent(category, cat -> new DefaultTypesRepository());
        Map<MetadataKey, MetadataType> previousTypes = typeRepository.getTypes();
        if (keys != null) {
            for (MetadataKey metadataKey : keys) {
                newTypes.put(metadataKey, previousTypes.get(metadataKey));
            }
        }
        typeRepository.clear();
        for (Map.Entry entry : newTypes.entrySet()) {
            typeRepository.addMetadataType((MetadataKey)entry.getKey(), (MetadataType)entry.getValue());
        }
    }

    private void initializeCustomTypes() {
        this.doSetMetadataKeys("#Custom Type#", "#Default Category#", new HashSet<MetadataKey>());
    }

    private ITypesRepository getCustomTypesRepository() {
        return this.typesRepository.get("#Custom Type#").get("#Default Category#");
    }

    private Optional<Map<String, ITypesRepository>> getModulesTypesRepositories(String moduleId) {
        return Optional.ofNullable(this.typesRepository.get(moduleId));
    }

    private Optional<ITypesRepository> getCategoryTypesRepositoryFor(String categoryId, Map<String, ITypesRepository> repositoryByCategory) {
        return Optional.ofNullable(repositoryByCategory.get(categoryId));
    }

    public void addCustomMetadataFile(String file, MetadataKey metadata) {
        ((UpdateMetadataListener)this.updateMetadataListener.getOrCompute()).addCustomType(file, metadata);
    }
}

