/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeFormat;
import org.mule.tooling.client.metadata.MetadataTypeOrigin;
import org.mule.tooling.client.metadata.enricher.MetadataEnricher;
import org.mule.tooling.model.messageflow.ComponentId;

public final class CompoundTypesManager
implements ITypesManager {
    private ITypesManager projectMetadataTypesCache;
    private ITypesManager domainMetadataTypesCache;

    public CompoundTypesManager(ITypesManager projectMetadataTypesCache, ITypesManager domainMetadataTypesCache) {
        this.projectMetadataTypesCache = projectMetadataTypesCache;
        this.domainMetadataTypesCache = domainMetadataTypesCache;
    }

    public void reload() {
        this.projectMetadataTypesCache.reload();
        this.domainMetadataTypesCache.reload();
    }

    public boolean isEmpty() {
        return this.projectMetadataTypesCache.isEmpty() && this.domainMetadataTypesCache.isEmpty();
    }

    public boolean hasMetadataKey(String module, String category, MetadataKey key) {
        boolean hasMetadataKey = this.domainMetadataTypesCache.hasMetadataKey(module, category, key);
        if (!hasMetadataKey) {
            hasMetadataKey = this.projectMetadataTypesCache.hasMetadataKey(module, category, key);
        }
        return hasMetadataKey;
    }

    public void setMetadataKeys(String module, String category, Set<MetadataKey> keys) {
        Set metadataKeysFromDomain = this.domainMetadataTypesCache.getMetadataKeys(module, category);
        if (metadataKeysFromDomain != null && !metadataKeysFromDomain.isEmpty()) {
            this.domainMetadataTypesCache.setMetadataKeys(module, category, keys);
        } else {
            this.projectMetadataTypesCache.setMetadataKeys(module, category, keys);
        }
    }

    public MetadataType getMetadataType(String module, String category, MetadataKey key) {
        MetadataType metadataKeyStructure = this.domainMetadataTypesCache.getMetadataType(module, category, key);
        if (metadataKeyStructure == null) {
            metadataKeyStructure = this.projectMetadataTypesCache.getMetadataType(module, category, key);
        }
        return metadataKeyStructure;
    }

    public MetadataKey getMetadataKeyByName(String module, String category, String name) {
        MetadataKey result = this.domainMetadataTypesCache.getMetadataKeyByName(module, category, name);
        if (result == null) {
            result = this.projectMetadataTypesCache.getMetadataKeyByName(module, category, name);
        }
        return result;
    }

    public Set<MetadataKey> getCustomMetadataKeys() {
        return this.getMetadataKeys("#Custom Type#", "#Default Category#");
    }

    public Set<MetadataKey> getMetadataKeys(String module, String category) {
        HashSet<MetadataKey> unionTypes = new HashSet<MetadataKey>(this.projectMetadataTypesCache.getMetadataKeys(module, category));
        unionTypes.addAll(this.domainMetadataTypesCache.getMetadataKeys(module, category));
        return unionTypes;
    }

    public void addCustomMetadata(MetadataKey key, MetadataType structure) {
        if (this.domainMetadataTypesCache.getCustomMetadataType(key) != null) {
            this.domainMetadataTypesCache.addCustomMetadata(key, structure);
        } else {
            this.projectMetadataTypesCache.addCustomMetadata(key, structure);
        }
    }

    public MetadataType getCustomMetadataType(MetadataKey key) {
        MetadataType metadataKeyStructure = this.domainMetadataTypesCache.getCustomMetadataType(key);
        if (metadataKeyStructure == null) {
            metadataKeyStructure = this.projectMetadataTypesCache.getCustomMetadataType(key);
        }
        return metadataKeyStructure;
    }

    public void removeCustomMetadata(MetadataKey key) {
        if (this.domainMetadataTypesCache.getCustomMetadataType(key) != null) {
            this.domainMetadataTypesCache.removeCustomMetadata(key);
        }
        if (this.projectMetadataTypesCache.getCustomMetadataType(key) != null) {
            this.projectMetadataTypesCache.removeCustomMetadata(key);
        }
    }

    public void removeMetadataType(String module, String category, MetadataKey key) {
        this.domainMetadataTypesCache.removeMetadataType(module, category, key);
        this.projectMetadataTypesCache.removeMetadataType(module, category, key);
    }

    public void removeMetadataTypes(String module) {
        this.domainMetadataTypesCache.removeMetadataTypes(module);
        this.projectMetadataTypesCache.removeMetadataTypes(module);
    }

    public void persistCustomTypes() {
        this.projectMetadataTypesCache.persist();
    }

    public void persist() {
        this.projectMetadataTypesCache.persist();
    }

    public void clearCustomTypes() {
        this.projectMetadataTypesCache.clearCustomTypes();
    }

    public void clearTypes(boolean deleteCustomTypes) {
        this.projectMetadataTypesCache.clearTypes(deleteCustomTypes);
    }

    public void enrich(MetadataEnricher enricher) {
        this.projectMetadataTypesCache.enrich(enricher);
    }

    public void removeEnricher(ComponentId componentId) {
        this.projectMetadataTypesCache.removeEnricher(componentId);
    }

    public Optional<MetadataEnricher> getEnricher(ComponentId componentId) {
        return this.projectMetadataTypesCache.getEnricher(componentId);
    }

    public Map<String, Set<MetadataKey>> getMetadataKeys(String module) {
        Map result = this.domainMetadataTypesCache.getMetadataKeys(module);
        if (result == null) {
            result = this.projectMetadataTypesCache.getMetadataKeys(module);
        }
        return result;
    }

    public void addCustomMetadataFile(String file, MetadataKey metadata) {
        this.projectMetadataTypesCache.addCustomMetadataFile(file, metadata);
    }

    public MetadataTypeFormat getAutogeneratedCustomMetadataFormat(String key) {
        return this.projectMetadataTypesCache.getAutogeneratedCustomMetadataFormat(key);
    }

    public String findCustomMetadataLocationByMetadataFormat(String content, String variableName, String locationKey, MetadataTypeFormat metadataTypeFormat) {
        return this.projectMetadataTypesCache.findCustomMetadataLocationByMetadataFormat(content, variableName, locationKey, metadataTypeFormat);
    }

    public String findCustomMetadataLocationByJsonExample(String jsonExample, String locationKey) {
        return this.projectMetadataTypesCache.findCustomMetadataLocationByJsonExample(jsonExample, locationKey);
    }

    public String findCustomMetadataLocationByMetadataName(String existingMetadataName, String locationKey) {
        return this.projectMetadataTypesCache.findCustomMetadataLocationByMetadataName(existingMetadataName, locationKey);
    }

    public String findCustomMetadataContentByMetadataName(String existingMetadataName) {
        return this.projectMetadataTypesCache.findCustomMetadataContentByMetadataName(existingMetadataName);
    }

    public String getCustomMetadataAdditionalInformation(String metadataName, String attribute) {
        return this.projectMetadataTypesCache.getCustomMetadataAdditionalInformation(metadataName, attribute);
    }

    public void deleteAutogeneratedMetadataByDocId(String docId, String flowName) {
        this.projectMetadataTypesCache.deleteAutogeneratedMetadataByDocId(docId, flowName);
    }

    public boolean isCustomMetadataOfMetadataTypeOrigin(String existingCustomMetadataName, MetadataTypeOrigin metadataTypeOrigin) {
        return this.projectMetadataTypesCache.isCustomMetadataOfMetadataTypeOrigin(existingCustomMetadataName, metadataTypeOrigin);
    }

    public void addAutogeneratedCustomMetadata(MetadataKey key, MetadataType structure) {
        this.projectMetadataTypesCache.addAutogeneratedCustomMetadata(key, structure);
    }
}

