/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata.api.utils;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AnyTypeBuilder;
import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BinaryTypeBuilder;
import org.mule.metadata.api.builder.BooleanTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.builder.DateTypeBuilder;
import org.mule.metadata.api.builder.IntersectionTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

public class MetadataToBuilder
extends MetadataTypeVisitor {
    private final BaseTypeBuilder valueTypeBuilder;

    public MetadataToBuilder(BaseTypeBuilder valueTypeBuilder) {
        this.valueTypeBuilder = valueTypeBuilder;
    }

    protected void defaultVisit(MetadataType metadataType) {
        throw new RuntimeException("Unhandled Type [" + metadataType.getClass().getName() + "]");
    }

    public void visitAnyType(AnyType anyType) {
        AnyTypeBuilder typeBuilder = this.valueTypeBuilder.anyType();
        for (TypeAnnotation annotation : anyType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
    }

    public void visitArrayType(ArrayType arrayType) {
        ArrayTypeBuilder typeBuilder = this.valueTypeBuilder.arrayType();
        for (TypeAnnotation annotation : arrayType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
        arrayType.getType().accept((MetadataTypeVisitor)new MetadataToBuilder(typeBuilder.of()));
    }

    public void visitBinaryType(BinaryType binaryType) {
        BinaryTypeBuilder typeBuilder = this.valueTypeBuilder.binaryType();
        for (TypeAnnotation annotation : binaryType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
    }

    public void visitBoolean(BooleanType booleanType) {
        BooleanTypeBuilder typeBuilder = this.valueTypeBuilder.booleanType();
        for (TypeAnnotation annotation : booleanType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
    }

    public void visitDateTime(DateTimeType dateTimeType) {
        DateTimeBuilder typeBuilder = this.valueTypeBuilder.dateTimeType();
        for (TypeAnnotation annotation : dateTimeType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
    }

    public void visitDate(DateType dateType) {
        DateTypeBuilder typeBuilder = this.valueTypeBuilder.dateType();
        for (TypeAnnotation annotation : dateType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
    }

    public void visitIntersection(IntersectionType intersectionType) {
        IntersectionTypeBuilder typeBuilder = this.valueTypeBuilder.intersectionType();
        for (TypeAnnotation annotation : intersectionType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
    }

    public void visitNull(NullType nullType) {
        this.valueTypeBuilder.nullType();
    }

    public void visitNumber(NumberType numberType) {
        this.valueTypeBuilder.numberType();
    }

    public void visitObject(ObjectType objectType) {
        ObjectTypeBuilder typeBuilder = this.valueTypeBuilder.objectType();
        for (TypeAnnotation annotation : objectType.getAnnotations()) {
            typeBuilder.with(annotation);
        }
        for (ObjectFieldType field : objectType.getFields()) {
            ObjectFieldTypeBuilder fieldBuilder = typeBuilder.addField();
            fieldBuilder.key(field.getKey().getName());
            field.getValue().accept((MetadataTypeVisitor)new MetadataToBuilder(fieldBuilder.value()));
        }
    }

    public void visitString(StringType stringType) {
        this.valueTypeBuilder.stringType();
    }
}

