/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.tooling.client.ToolingMetadataKeyBuilder;
import org.mule.tooling.client.api.metadata.MetadataKey;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataTypeProxy;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.metadata.annotations.ContentAnnotation;
import org.mule.tooling.metadata.types.utils.DataWeaveMetadataTypeWriter;
import org.mule.tooling.metadata.utils.MetadataUtils;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class UpdateMetadataListener
implements FileChangedEventListener,
IMuleProjectEventListener {
    HashMap<String, ArrayList<MetadataKey>> types = new HashMap();
    ITypesManager manager;
    EventBusHelper eventBusHelper;
    IProject project;

    public UpdateMetadataListener(ITypesManager manager, IProject project) {
        this.manager = manager;
        this.eventBusHelper = new EventBusHelper();
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_PROJECT_EVENT, (IEventHandler)this);
        this.project = project;
    }

    public void onFileChanged(FileChangedEvent event) {
        String file;
        ArrayList<MetadataKey> metadatas;
        if (!event.getFile().exists()) {
            return;
        }
        if (event.getFile().getProject().equals((Object)this.project) && (metadatas = this.types.get(file = event.getFile().getFullPath().makeRelativeTo(event.getFile().getProject().getFolder("src/main/resources").getFullPath()).toString())) != null && !file.endsWith(".wev")) {
            HashMap<Class<ContentAnnotation>, ContentAnnotation> annotations = new HashMap<Class<ContentAnnotation>, ContentAnnotation>();
            String exampleAbsolutePath = event.getFile().getRawLocation().makeAbsolute().toString();
            try {
                MetadataType metadataType = MetadataUtils.createMetadataFromJsonExample(exampleAbsolutePath);
                if (metadataType instanceof AnyType) {
                    throw new IllegalArgumentException("The provided JSON could not be parsed as JSON Example");
                }
                int i = 0;
                while (i < metadatas.size()) {
                    MetadataType metadata = this.manager.getCustomMetadataType(metadatas.get(i));
                    DataWeaveMetadataTypeWriter typeWriter = new DataWeaveMetadataTypeWriter(metadatas.get(i).getDisplayName());
                    ContentAnnotation content = new ContentAnnotation(typeWriter.toString(metadataType));
                    metadata.getAnnotations().forEach(element -> {
                        if (element.getClass() != ContentAnnotation.class) {
                            annotations.put((Class<ContentAnnotation>)element.getClass(), (ContentAnnotation)element);
                        }
                    });
                    annotations.put(ContentAnnotation.class, content);
                    this.manager.addCustomMetadata(ToolingMetadataKeyBuilder.newKey((String)metadatas.get(i).getDisplayName()).build(), MetadataTypeProxy.proxying((MetadataType)metadataType, annotations));
                    ++i;
                }
                WorkspaceJob wsJob = new WorkspaceJob("Persist Types"){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        UpdateMetadataListener.this.manager.persist();
                        return Status.OK_STATUS;
                    }
                };
                wsJob.setRule((ISchedulingRule)this.project.getProject());
                wsJob.schedule();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IllegalArgumentException("The provided JSON could not be parsed as JSON Example");
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("The provided JSON could not be parsed as JSON Example");
            }
        }
    }

    public void addCustomType(String file, MetadataKey metadata) {
        ArrayList<MetadataKey> metadatas = this.types.get(file);
        if (metadatas != null) {
            if (!this.isAlreadyStored(metadatas, metadata)) {
                metadatas.add(metadata);
            }
        } else {
            ArrayList<MetadataKey> metadataArray = new ArrayList<MetadataKey>();
            metadataArray.add(metadata);
            this.types.put(file, metadataArray);
        }
    }

    private boolean isAlreadyStored(ArrayList<MetadataKey> metadatas, MetadataKey metadata) {
        if (metadatas.contains(metadata)) {
            return true;
        }
        for (MetadataKey currentMeta : metadatas) {
            if (!currentMeta.getId().equals(metadata.getId())) continue;
            return true;
        }
        return false;
    }

    public void removeCustomType(String file, String metadataId) {
        ArrayList<MetadataKey> metadatas = this.types.get(file);
        int i = 0;
        while (i < metadatas.size()) {
            if (metadatas.get(i).getId().equals(metadataId)) {
                metadatas.remove(i);
                break;
            }
            ++i;
        }
    }

    public void onMuleProjectOpened(IProject project) {
    }

    public void onMuleProjectClosed(IProject project) {
        if (this.project.equals((Object)project)) {
            this.eventBusHelper.unregister();
        }
    }
}

