/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.metadata;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.mule.tooling.client.api.datasense.storage.MetadataCacheStorage;
import org.mule.tooling.client.metadata.IProjectMetadataManager;
import org.mule.tooling.client.metadata.ITypesManager;
import org.mule.tooling.client.metadata.MetadataCacheStorageComponent;
import org.mule.tooling.client.metadata.ProjectMetadata;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.resource.FileChangedEvent;
import org.mule.tooling.core.event.resource.FileChangedEventListener;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.metadata.cache.CompoundTypesManager;
import org.mule.tooling.metadata.cache.DefaultTypesManager;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.utils.eventbus.IEventHandler;

public final class ProjectMetadataManager
implements IProjectMetadataManager {
    public static final String ORG_MULE_TOOLING_STUDIO_PROJECT = "org.mule.tooling.studio.project";
    private final Map<String, ProjectMetadata> projectMetadata = new ConcurrentHashMap<String, ProjectMetadata>();

    public ProjectMetadataManager() {
        MuleCorePlugin.getEventBus().registerListener(CoreEventTypes.ResourceEvents.ON_FILE_RESOURCE_CHANGED, (IEventHandler)((FileChangedEventListener)event -> {
            if (!event.isInOutputLocation()) {
                if (event.isEventType(FileChangedEvent.ChangeType.CHANGED)) {
                    this.onFileChange(event.getFile());
                } else if (event.isEventType(FileChangedEvent.ChangeType.DELETED)) {
                    this.onFileDeleted(event.getFile());
                }
            }
        }));
    }

    public void initializeProjectMetadata(IMuleProject project) {
        this.getOrCreateProjectMetadata(project);
    }

    private ProjectMetadata getOrCreateProjectMetadata(IMuleProject project) {
        return this.projectMetadata.computeIfAbsent(project.getName(), p -> this.buildProjectMetadata(project));
    }

    public void removeProjectMetadata(IProject project) {
        this.projectMetadata.remove(project.getName());
    }

    public ITypesManager getTypesManager(IMuleProject project) {
        IMuleDomain domain;
        IMuleApplicationProject applicationProject;
        if (MuleProjectKind.APPLICATION.classifies(project) && !(applicationProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(project)).hasDefaultDomain() && (domain = applicationProject.getDomain()) != null && domain instanceof IMuleDomainProject) {
            return new CompoundTypesManager(this.getProjectTypes(project), this.getProjectTypes((IMuleProject)((IMuleDomainProject)domain)));
        }
        if (this.hasDomainNature(project.getProject())) {
            return this.getProjectTypes((IMuleProject)MuleProjectKind.DOMAIN.adapt(project));
        }
        return this.getProjectTypes(project);
    }

    private boolean hasDomainNature(IProject project) {
        try {
            return CoreUtils.hasMuleDomainNature((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private ITypesManager getProjectTypes(IMuleProject project) {
        return this.getOrCreateProjectMetadata(project).getTypesManager();
    }

    private ProjectMetadata buildProjectMetadata(IMuleProject project) {
        return new ProjectMetadata((ITypesManager)new DefaultTypesManager(project));
    }

    private void onFileChange(IFile resource) {
        IProject project = resource.getProject();
        if (this.isAccessible(project)) {
            IMuleProject muleProject = MuleRuntime.create((IProject)project);
            if (MuleResourceUtils.isApplicationTypesFile((IResource)resource) || MuleResourceUtils.resourcesAffectsTypeCatalog((IMuleProject)muleProject, (IResource)resource)) {
                this.reloadTypes(muleProject);
            }
        }
    }

    private void onFileDeleted(IFile resource) {
        IProject project = resource.getProject();
        if (this.isAccessible(project)) {
            IMuleProject muleProject = MuleRuntime.create((IProject)project);
            if (MuleResourceUtils.isApplicationTypesFile((IResource)resource)) {
                ((MetadataTypesManager)muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager().clearCustomTypes();
            }
        }
    }

    private boolean isAccessible(IProject project) {
        return project.exists() && project.isAccessible();
    }

    private void reloadTypes(IMuleProject project) {
        LoadTypes loadTypesJob = new LoadTypes("Reload types...", project);
        loadTypesJob.setPriority(20);
        loadTypesJob.schedule();
    }

    public MetadataCacheStorage getMetadataCache(IMuleProject project) {
        return ((MetadataCacheStorageComponent)project.getProjectComponent(MetadataCacheStorageComponent.class)).getStorage();
    }

    private final class LoadTypes
    extends Job {
        private final IMuleProject project;

        private LoadTypes(String name, IMuleProject project) {
            super(name);
            this.project = project;
        }

        protected IStatus run(IProgressMonitor monitor) {
            ((MetadataTypesManager)this.project.getProjectComponent(MetadataTypesManager.class)).getTypesManager().reload();
            return Status.OK_STATUS;
        }
    }
}

