/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.platform.interaction;

import com.mulesoft.anypoint.backoff.configuration.BackoffConfiguration;
import com.mulesoft.anypoint.backoff.configuration.BackoffConfigurationSupplier;
import com.mulesoft.anypoint.backoff.scheduler.BackoffScheduler;
import com.mulesoft.anypoint.backoff.scheduler.configuration.SchedulingConfiguration;
import com.mulesoft.anypoint.backoff.scheduler.factory.BackoffSchedulerFactory;
import com.mulesoft.anypoint.backoff.scheduler.runnable.BackoffRunnable;
import com.mulesoft.anypoint.backoff.session.BackoffBarrier;
import com.mulesoft.anypoint.backoff.session.PlatformBackoffBarrier;
import com.mulesoft.mule.runtime.gw.api.config.GatewayConfiguration;
import com.mulesoft.mule.runtime.gw.util.NamedThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatewayPoller {
    private static final Logger LOGGER = LoggerFactory.getLogger(GatewayPoller.class);
    protected final GatewayConfiguration configuration;
    private final String name;
    private final BackoffSchedulerFactory schedulerFactory;
    private final BackoffConfigurationSupplier backoffConfigurationSupplier;
    private BackoffScheduler scheduler;
    private BackoffRunnable runnable;

    public GatewayPoller(String name, GatewayConfiguration configuration, BackoffSchedulerFactory schedulerFactory, BackoffConfigurationSupplier backoffConfigurationSupplier) {
        this.name = name;
        this.configuration = configuration;
        this.schedulerFactory = schedulerFactory;
        this.backoffConfigurationSupplier = backoffConfigurationSupplier;
    }

    public BackoffRunnable schedule() {
        if (this.scheduler == null) {
            this.scheduler = this.schedulerFactory.create(Executors.newScheduledThreadPool(1, (ThreadFactory)new NamedThreadFactory(this.name)));
            this.runnable = this.runnable(this.backoffBarrier(), this.backoffConfiguration());
            this.scheduler.scheduleWithFixedDelay(this.runnable, this.configuration());
            LOGGER.debug("{} Runnable started successfully", (Object)this.name);
        }
        return this.runnable;
    }

    protected abstract BackoffRunnable runnable(BackoffBarrier var1, BackoffConfiguration var2);

    public abstract SchedulingConfiguration configuration();

    public void shutdown() {
        if (this.scheduler != null) {
            this.scheduler.dispose();
        }
    }

    private BackoffBarrier backoffBarrier() {
        return new PlatformBackoffBarrier();
    }

    private BackoffConfiguration backoffConfiguration() {
        return this.backoffConfigurationSupplier.forScheduling(this.configuration.platformClient().getOutagesStatusCodes(), this.configuration.platformClient().backoffEnabled().booleanValue());
    }
}

