/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.deployment.contracts;

import com.mulesoft.mule.runtime.gw.api.client.Client;
import com.mulesoft.mule.runtime.gw.api.contract.Contract;
import com.mulesoft.mule.runtime.gw.api.contract.NoSla;
import com.mulesoft.mule.runtime.gw.api.contract.Sla;
import com.mulesoft.mule.runtime.gw.api.contract.tier.Tier;
import com.mulesoft.mule.runtime.gw.client.dto.PlatformContractAdapter;
import com.mulesoft.mule.runtime.gw.deployment.contracts.Snapshot;
import com.mulesoft.mule.runtime.gw.logging.GatewayMuleAppLoggerFactory;
import com.mulesoft.mule.runtime.gw.model.contracts.ClientFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class ContractSnapshot
implements Snapshot {
    private static final Logger LOGGER = GatewayMuleAppLoggerFactory.getLogger(ContractSnapshot.class);
    private Optional<Map<Integer, Sla>> slas = Optional.empty();
    private Optional<List<Contract>> contracts = Optional.empty();
    private final ClientFactory clientFactory;

    public ContractSnapshot(ClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public ContractSnapshot(List<Contract> storedContracts, ClientFactory clientFactory) {
        this.contracts = Optional.of(storedContracts);
        this.slas = Optional.of(storedContracts.stream().map(Contract::sla).filter(sla -> sla.id() != 0).distinct().collect(Collectors.toMap(Sla::id, sla -> sla)));
        this.clientFactory = clientFactory;
    }

    @Override
    public Optional<List<Contract>> contracts() {
        return this.contracts.map(list -> list.stream().map(contract -> this.newContract(contract.client(), this.slas.map(slas -> (Sla)slas.getOrDefault(contract.sla().id(), new NoSla())).orElse((Sla)new NoSla()))).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<Sla>> slas() {
        return this.slas.map(map -> new ArrayList(map.values()));
    }

    @Override
    public Snapshot platformSlas(List<Sla> platformSlas) {
        Map inMemorySlas = this.slas.orElseGet(HashMap::new);
        if (LOGGER.isDebugEnabled()) {
            this.logSlaChanges(platformSlas, inMemorySlas);
        }
        inMemorySlas.putAll(platformSlas.stream().collect(Collectors.toMap(Sla::id, sla -> sla)));
        this.slas = Optional.of(inMemorySlas);
        return this;
    }

    private void logSlaChanges(List<Sla> platformSlas, Map<Integer, Sla> inMemorySlas) {
        List newSlas = platformSlas.stream().filter(sla -> !inMemorySlas.containsKey(sla.id())).collect(Collectors.toList());
        List modifiedSlas = platformSlas.stream().filter(sla -> inMemorySlas.containsKey(sla.id()) && !sla.equals(inMemorySlas.get(sla.id()))).collect(Collectors.toList());
        List unmodifiedSlas = platformSlas.stream().filter(sla -> inMemorySlas.containsKey(sla.id()) && sla.equals(inMemorySlas.get(sla.id()))).collect(Collectors.toList());
        List slasNotReturnedByPlatform = inMemorySlas.values().stream().filter(inMemorySla -> platformSlas.stream().noneMatch(platformSla -> platformSla.id().equals(inMemorySla.id()))).collect(Collectors.toList());
        LOGGER.debug("Received new SLAs: {}", newSlas);
        LOGGER.debug("The following SLAs were modified: {}", modifiedSlas);
        LOGGER.debug("The following SLAs were not modified: {}", unmodifiedSlas);
        LOGGER.debug("The following SLAs were not returned by the platform: {}", slasNotReturnedByPlatform);
    }

    @Override
    public Snapshot platformContracts(List<PlatformContractAdapter> platformContractAdapters) {
        List inMemoryContracts = this.contracts.orElseGet(ArrayList::new);
        List<Contract> platformContracts = platformContractAdapters.stream().map(contract -> this.newContract(this.clientFactory.create(contract.clientId(), contract.clientSecret(), contract.clientName()), (Sla)(contract.slaId().isPresent() ? new Sla((Integer)contract.slaId().get(), new Tier[0]) : new NoSla()))).collect(Collectors.toList());
        if (LOGGER.isDebugEnabled()) {
            this.logContractChanges(platformContracts, inMemoryContracts);
        }
        this.contracts = Optional.of(platformContracts);
        return this;
    }

    private void logContractChanges(List<Contract> platformContracts, List<Contract> inMemoryContracts) {
        List newContracts = platformContracts.stream().filter(platformContract -> inMemoryContracts.stream().noneMatch(this.contractClientId((Contract)platformContract))).collect(Collectors.toList());
        List modifiedContracts = platformContracts.stream().filter(platformContract -> inMemoryContracts.stream().anyMatch(this.contractClientId((Contract)platformContract))).collect(Collectors.toList());
        List removedContracts = inMemoryContracts.stream().filter(inMemoryContract -> platformContracts.stream().noneMatch(this.contractClientId((Contract)inMemoryContract))).collect(Collectors.toList());
        LOGGER.debug("Received new Contracts: {}", newContracts);
        LOGGER.debug("The following Contracts were modified: {}", modifiedContracts);
        LOGGER.debug("The following Contracts were removed: {}", removedContracts);
    }

    private Predicate<Contract> contractClientId(Contract platformContract) {
        return inMemoryContract -> inMemoryContract.client().id().equals(platformContract.client().id());
    }

    private Contract newContract(Client client, Sla sla) {
        return Contract.builder().withClient(client).withSla(sla).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContractSnapshot that = (ContractSnapshot)o;
        if (this.slas != null ? !this.slas.equals(that.slas) : that.slas != null) {
            return false;
        }
        return this.contracts != null ? this.contracts.equals(that.contracts) : that.contracts == null;
    }

    public int hashCode() {
        int result = this.slas != null ? this.slas.hashCode() : 0;
        result = 31 * result + (this.contracts != null ? this.contracts.hashCode() : 0);
        return result;
    }
}

