/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.boot.internal;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;

public class ContextSelectorWrapper
implements ContextSelector {
    private static final LazyValue<LoggerContext> DEFAULT_LOGGER_CONTEXT = new LazyValue<LoggerContext>(() -> new LoggerContext("boot"));
    private ContextSelector delegate;
    private Consumer<ContextSelector> delegateDisposer;

    public ContextSelectorWrapper() {
    }

    public ContextSelectorWrapper(ContextSelector delegate, Consumer<ContextSelector> delegateDisposer) {
        this.setDelegate(delegate, delegateDisposer);
    }

    public void setDelegate(ContextSelector delegate, Consumer<ContextSelector> delegateDisposer) {
        this.delegate = delegate;
        this.delegateDisposer = delegateDisposer;
    }

    public void disposeDelegate() {
        if (this.delegate != null && this.delegateDisposer != null) {
            this.delegateDisposer.accept(this.delegate);
        }
    }

    @Override
    public void shutdown(String fqcn, ClassLoader loader, boolean currentContext, boolean allContexts) {
        if (this.delegate != null) {
            this.delegate.shutdown(fqcn, loader, currentContext, allContexts);
        }
    }

    @Override
    public boolean hasContext(String fqcn, ClassLoader loader, boolean currentContext) {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.hasContext(fqcn, loader, currentContext);
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext) {
        if (this.delegate == null) {
            return DEFAULT_LOGGER_CONTEXT.get();
        }
        return this.delegate.getContext(fqcn, loader, currentContext);
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, Map.Entry<String, Object> entry, boolean currentContext) {
        if (this.delegate == null) {
            return DEFAULT_LOGGER_CONTEXT.get();
        }
        return this.delegate.getContext(fqcn, loader, entry, currentContext);
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, boolean currentContext, URI configLocation) {
        if (this.delegate == null) {
            return DEFAULT_LOGGER_CONTEXT.get();
        }
        return this.delegate.getContext(fqcn, loader, currentContext, configLocation);
    }

    @Override
    public LoggerContext getContext(String fqcn, ClassLoader loader, Map.Entry<String, Object> entry, boolean currentContext, URI configLocation) {
        if (this.delegate == null) {
            return DEFAULT_LOGGER_CONTEXT.get();
        }
        return this.delegate.getContext(fqcn, loader, entry, currentContext, configLocation);
    }

    @Override
    public List<LoggerContext> getLoggerContexts() {
        if (this.delegate == null) {
            return Collections.singletonList(DEFAULT_LOGGER_CONTEXT.get());
        }
        return this.delegate.getLoggerContexts();
    }

    @Override
    public void removeContext(LoggerContext context) {
        if (this.delegate != null) {
            this.delegate.removeContext(context);
        }
    }

    @Override
    public boolean isClassLoaderDependent() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.isClassLoaderDependent();
    }

    private static class LazyValue<T> {
        private final Supplier<T> supplier;
        private T value;

        public LazyValue(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T get() {
            if (this.value == null) {
                LazyValue lazyValue = this;
                synchronized (lazyValue) {
                    if (this.value == null) {
                        this.value = this.supplier.get();
                    }
                }
            }
            return this.value;
        }
    }
}

