/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.boot.api;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.config.xml.XmlConfigurationFactory;
import org.apache.logging.log4j.core.impl.Log4jContextFactory;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.apache.logging.log4j.core.util.Cancellable;
import org.apache.logging.log4j.core.util.ShutdownCallbackRegistry;
import org.mule.runtime.module.log4j.boot.api.AsyncLoggerExceptionHandler;
import org.mule.runtime.module.log4j.boot.internal.ContextSelectorWrapper;
import org.slf4j.LoggerFactory;

public class MuleLog4jContextFactory
extends Log4jContextFactory
implements ShutdownCallbackRegistry {
    private static final String LOG_CONFIGURATION_FACTORY_PROPERTY = "log4j.configurationFactory";
    private static final String DEFAULT_LOG_CONFIGURATION_FACTORY = XmlConfigurationFactory.class.getName();
    private static final String ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY = "AsyncLoggerConfig.ExceptionHandler";
    private static final String DEFAULT_ASYNC_LOGGER_EXCEPTION_HANDLER = AsyncLoggerExceptionHandler.class.getName();

    public static MuleLog4jContextFactory createAndInstall() {
        LoggerFactory.getLogger("triggerDefaultFactoryCreation");
        System.setProperty("log4j2.loggerContextFactory", MuleLog4jContextFactory.class.getName());
        MuleLog4jContextFactory log4jContextFactory = new MuleLog4jContextFactory();
        LogManager.setFactory(log4jContextFactory);
        return log4jContextFactory;
    }

    public MuleLog4jContextFactory() {
        super(new ContextSelectorWrapper(), new MuleShutdownCallbackRegistry());
        this.initialise();
    }

    public MuleLog4jContextFactory(ContextSelector contextSelector, Consumer<ContextSelector> disposer) {
        super(new ContextSelectorWrapper(contextSelector, disposer), new MuleShutdownCallbackRegistry());
        this.initialise();
    }

    public void setContextSelector(ContextSelector contextSelector, Consumer<ContextSelector> disposer) {
        ContextSelector selector = this.getSelector();
        if (selector instanceof ContextSelectorWrapper) {
            ((ContextSelectorWrapper)selector).setDelegate(contextSelector, disposer);
        }
    }

    protected void initialise() {
        this.setupConfigurationFactory();
        this.setupAsyncLoggerExceptionHandler();
    }

    private void setupConfigurationFactory() {
        System.setProperty(LOG_CONFIGURATION_FACTORY_PROPERTY, DEFAULT_LOG_CONFIGURATION_FACTORY);
    }

    private void setupAsyncLoggerExceptionHandler() {
        String handler = System.getProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY);
        if (MuleLog4jContextFactory.isBlank(handler)) {
            System.setProperty(ASYNC_LOGGER_EXCEPTION_HANDLER_PROPERTY, DEFAULT_ASYNC_LOGGER_EXCEPTION_HANDLER);
        }
    }

    public void dispose() {
        ContextSelector selector = this.getSelector();
        if (selector instanceof ContextSelectorWrapper) {
            ((ContextSelectorWrapper)selector).disposeDelegate();
        }
        MuleShutdownCallbackRegistry shutdownCallbackRegistry = (MuleShutdownCallbackRegistry)this.getShutdownCallbackRegistry();
        shutdownCallbackRegistry.dispose();
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen = MuleLog4jContextFactory.length(cs);
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int length(CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    private static class MuleShutdownCallbackRegistry
    implements ShutdownCallbackRegistry {
        private final ExecutorService executorService = Executors.newCachedThreadPool(runnable2 -> new Thread(runnable2, "[MuleRuntime].log4j.shudownhook"));
        private final List<Runnable> hooks = new ArrayList<Runnable>();

        private MuleShutdownCallbackRegistry() {
        }

        @Override
        public Cancellable addShutdownCallback(final Runnable callback) {
            this.hooks.add(callback);
            return new Cancellable(){

                @Override
                public void cancel() {
                    hooks.remove(callback);
                }

                @Override
                public void run() {
                    callback.run();
                }
            };
        }

        public void dispose() {
            for (Runnable hook : new ArrayList<Runnable>(this.hooks)) {
                this.executorService.submit(hook);
            }
            try {
                this.executorService.awaitTermination(1000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.executorService.shutdownNow();
        }
    }
}

