/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.boot.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.mule.runtime.module.boot.internal.BootstrapConfigurationException;
import org.mule.runtime.module.boot.internal.BootstrapConfigurer;
import org.mule.runtime.module.boot.internal.MuleContainerFactory;
import org.mule.runtime.module.boot.internal.MuleContainerWrapper;

public abstract class AbstractMuleContainerWrapper
implements MuleContainerWrapper {
    private final Collection<BootstrapConfigurer> bootstrapConfigurers = new ArrayList<BootstrapConfigurer>();

    @Override
    public void addBootstrapConfigurer(BootstrapConfigurer bootstrapConfigurer) {
        this.bootstrapConfigurers.add(bootstrapConfigurer);
    }

    @Override
    public void configureAndStart(MuleContainerFactory muleContainerFactory, CommandLine commandLine) {
        if (this.configure()) {
            System.out.println("Starting the Mule Container...");
            this.start(muleContainerFactory, commandLine.getArgs());
        }
    }

    private boolean configure() {
        try {
            for (BootstrapConfigurer bootstrapConfigurer : this.bootstrapConfigurers) {
                if (bootstrapConfigurer.configure()) continue;
                this.haltAndCatchFire(0, null);
                return false;
            }
            return true;
        }
        catch (BootstrapConfigurationException e) {
            this.haltAndCatchFire(e.getExitCode(), e.getMessage());
            return false;
        }
    }

    protected Future<Boolean> getAllConfigurersReady() {
        return CompletableFuture.supplyAsync(this::waitAllConfigurersReady);
    }

    private boolean waitAllConfigurersReady() {
        try {
            for (BootstrapConfigurer bootstrapConfigurer : this.bootstrapConfigurers) {
                bootstrapConfigurer.await();
            }
            return true;
        }
        catch (BootstrapConfigurationException e) {
            this.haltAndCatchFire(e.getExitCode(), e.getMessage());
            return false;
        }
    }

    @Override
    public void dispose() {
        ArrayList<ConfigurerDisposalException> disposalExceptions = new ArrayList<ConfigurerDisposalException>();
        for (BootstrapConfigurer bootstrapConfigurer : this.bootstrapConfigurers) {
            try {
                bootstrapConfigurer.dispose();
            }
            catch (Throwable t2) {
                disposalExceptions.add(new ConfigurerDisposalException(bootstrapConfigurer, t2));
            }
        }
        if (!disposalExceptions.isEmpty()) {
            if (disposalExceptions.size() == 1) {
                throw new RuntimeException(String.format("Error disposing configurer: %s", disposalExceptions.get(0)), (Throwable)disposalExceptions.get(0));
            }
            String joinedMsgs = disposalExceptions.stream().map(Throwable::toString).collect(Collectors.joining(",\n\t"));
            RuntimeException disposalException = new RuntimeException(String.format("Found multiple errors disposing the configurers: [\n\t%s\n]", joinedMsgs));
            disposalExceptions.forEach(disposalException::addSuppressed);
            throw disposalException;
        }
    }

    protected abstract void start(MuleContainerFactory var1, String[] var2);

    private static class ConfigurerDisposalException
    extends Exception {
        private final String configurerClassName;

        public ConfigurerDisposalException(BootstrapConfigurer configurer, Throwable cause) {
            super(cause);
            this.configurerClassName = configurer.getClass().getName();
        }

        @Override
        public String toString() {
            return String.format("%s: %s", this.configurerClassName, super.toString());
        }
    }
}

