/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.serialization.impl.gson.adapter;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.List;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.ParameterValueVisitor;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.SimpleValueType;

public class ParameterValueTypeAdapter
extends TypeAdapter<ParameterValue> {
    private static final String TEXT = "text";
    private static final String IS_CDATA = "isCData";
    private static final String TYPE = "type";

    @Override
    public void write(JsonWriter jsonWriter, ParameterValue parameter) throws IOException {
        if (parameter == null) {
            jsonWriter.nullValue();
            return;
        }
        parameter.accept(this.getValueVisitor(jsonWriter));
    }

    @Override
    public ParameterValue read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        JsonElement parse = new JsonParser().parse(in);
        return this.getParameterValue(parse);
    }

    private ParameterValueVisitor getValueVisitor(final JsonWriter jsonWriter) {
        return new ParameterValueVisitor(){

            @Override
            public void visitSimpleValue(ParameterSimpleValue text) {
                ParameterValueTypeAdapter.this.writeSimpleValue(text, jsonWriter);
            }

            @Override
            public void visitListValue(ParameterListValue list) {
                ParameterValueTypeAdapter.this.writeListValue(list, jsonWriter);
            }

            @Override
            public void visitObjectValue(ParameterObjectValue objectValue) {
                ParameterValueTypeAdapter.this.writeObjectValue(objectValue, jsonWriter);
            }
        };
    }

    private void writeObjectValue(ParameterObjectValue objectValue, JsonWriter jsonWriter) {
        try {
            JsonWriter object = jsonWriter.beginObject();
            this.writeObjectParameters(objectValue, object);
            if (objectValue.getTypeId() != null && !objectValue.getTypeId().trim().isEmpty()) {
                object.name("typeId").value(objectValue.getTypeId());
            }
            object.endObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObjectParameters(ParameterObjectValue objectValue, JsonWriter object) throws IOException {
        object.name("fields").beginObject();
        objectValue.getParameters().forEach((name, v) -> {
            try {
                JsonWriter field = object.name((String)name);
                v.accept(this.getValueVisitor(field));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        object.endObject();
    }

    private void writeListValue(ParameterListValue list, JsonWriter jsonWriter) {
        List<ParameterValue> values2 = list.getValues();
        try {
            JsonWriter array = jsonWriter.beginArray();
            values2.forEach(v -> v.accept(this.getValueVisitor(array)));
            array.endArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeSimpleValue(ParameterSimpleValue value, JsonWriter jsonWriter) {
        try {
            jsonWriter.beginObject();
            jsonWriter.name(TEXT).value(value.getValue());
            jsonWriter.name(IS_CDATA).value(value.isCData());
            if (value.getType() != null) {
                jsonWriter.name(TYPE).value(value.getType().toString());
            }
            jsonWriter.endObject();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ParameterValue getParameterValue(JsonElement jsonElement) {
        if (jsonElement.isJsonArray()) {
            return this.loadListValue(jsonElement);
        }
        if (jsonElement.isJsonObject()) {
            JsonObject object = jsonElement.getAsJsonObject();
            JsonElement text = object.get(TEXT);
            if (text != null && object.get(IS_CDATA) != null) {
                JsonElement type = object.get(TYPE);
                SimpleValueType typeValue = type == null ? SimpleValueType.STRING : SimpleValueType.valueOf(type.getAsString());
                return object.get(IS_CDATA).getAsBoolean() ? ParameterSimpleValue.cdata(text.getAsString(), typeValue) : ParameterSimpleValue.plain(text.getAsString(), typeValue);
            }
            return this.loadObjectValue(object);
        }
        return null;
    }

    private ParameterValue loadListValue(JsonElement jsonElement) {
        JsonArray array = jsonElement.getAsJsonArray();
        ParameterListValue.Builder listBuilder = ParameterListValue.builder();
        array.forEach(e -> listBuilder.withValue(this.getParameterValue((JsonElement)e)));
        return listBuilder.build();
    }

    private ParameterValue loadObjectValue(JsonObject object) {
        JsonElement parameters;
        ParameterObjectValue.Builder objectBuilder = ParameterObjectValue.builder();
        JsonElement id = object.get("typeId");
        if (id != null) {
            objectBuilder.ofType(id.getAsString());
        }
        if ((parameters = object.get("fields")) != null) {
            parameters.getAsJsonObject().entrySet().forEach(field -> objectBuilder.withParameter((String)field.getKey(), this.getParameterValue((JsonElement)field.getValue())));
        }
        return objectBuilder.build();
    }
}

