/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.app.declaration.api;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.app.declaration.api.ComponentElementDeclarationVisitor;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclarationContainer;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclarationVisitor;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;

@NoExtend
public abstract class ComponentElementDeclaration<T extends ComponentElementDeclaration>
extends ParameterizedElementDeclaration
implements ElementDeclarationContainer {
    private String configRef;
    private List<ComponentElementDeclaration> components = new LinkedList<ComponentElementDeclaration>();

    public abstract void accept(ComponentElementDeclarationVisitor var1);

    public void setConfigRef(String configRef) {
        this.configRef = configRef;
    }

    public String getConfigRef() {
        return this.configRef;
    }

    public List<ComponentElementDeclaration> getComponents() {
        return Collections.unmodifiableList(this.components);
    }

    public T addComponent(ComponentElementDeclaration declaration) {
        this.components.add(declaration);
        return (T)this;
    }

    public T addComponent(int index, ComponentElementDeclaration declaration) {
        this.components.add(index, declaration);
        return (T)this;
    }

    @Override
    public <T extends ElementDeclaration> Optional<T> findElement(List<String> parts) {
        if (parts.isEmpty()) {
            return Optional.of(this);
        }
        if (!this.components.isEmpty()) {
            String identifier = parts.get(0);
            if (StringUtils.isNumeric(identifier) && Integer.parseInt(identifier) < this.components.size()) {
                return this.components.get(Integer.parseInt(identifier)).findElement(parts.subList(1, parts.size()));
            }
            if (identifier.equals("errorHandler")) {
                ComponentElementDeclaration last = this.components.get(this.components.size() - 1);
                return last instanceof ComponentElementDeclaration ? last.findElement(parts.subList(1, parts.size())) : Optional.empty();
            }
            if (this.isProcessorLocation(parts)) {
                int processorIndex = Integer.parseInt(parts.get(1));
                if (this.components.get(0) instanceof SourceElementDeclaration) {
                    if (this.components.size() == 1) {
                        return Optional.empty();
                    }
                    ++processorIndex;
                }
                return this.components.get(processorIndex).findElement(parts.subList(2, parts.size()));
            }
        }
        return super.findElement(parts);
    }

    @Override
    public void accept(ParameterizedElementDeclarationVisitor visitor) {
        visitor.visitComponentElementDeclaration(this);
    }

    private boolean isProcessorLocation(List<String> parts) {
        return parts.get(0).equals("processors") && parts.size() > 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ComponentElementDeclaration that = (ComponentElementDeclaration)o;
        return Objects.equals(this.configRef, that.configRef) && Objects.equals(this.components, that.components);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.configRef, this.components);
    }
}

