/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.metadata;

import java.util.ServiceLoader;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.DataTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractDataTypeBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDataTypeBuilderFactory.class);
    private static final AbstractDataTypeBuilderFactory DEFAULT_FACTORY;

    static final AbstractDataTypeBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    protected abstract DataTypeBuilder create();

    protected abstract DataTypeBuilder create(DataType var1);

    static {
        try {
            AbstractDataTypeBuilderFactory factory2 = ServiceLoader.load(AbstractDataTypeBuilderFactory.class, AbstractDataTypeBuilderFactory.class.getClassLoader()).iterator().next();
            LOGGER.debug(String.format("Loaded AbstractDataTypeBuilderFactory implementation '%s' from classloader '%s'", factory2.getClass().getName(), factory2.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory2;
        }
        catch (Throwable t2) {
            LOGGER.error("Error loading AbstractDataTypeBuilderFactory implementation.", t2);
            throw t2;
        }
    }
}

