/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.message;

import java.io.Serializable;
import java.util.OptionalInt;

public final class ItemSequenceInfo
implements Serializable {
    public static final String NOT_SET = "<not set>";
    private static final long serialVersionUID = -2294860079566380331L;
    private final int position;
    private final int sequenceSize;

    public static ItemSequenceInfo of(int position) {
        return new ItemSequenceInfo(position, OptionalInt.empty());
    }

    public static ItemSequenceInfo of(int position, int sequenceSize) {
        return new ItemSequenceInfo(position, OptionalInt.of(sequenceSize));
    }

    private ItemSequenceInfo(int position, OptionalInt sequenceSize) {
        this.position = position;
        this.sequenceSize = sequenceSize.orElse(-1);
    }

    public int getPosition() {
        return this.position;
    }

    public OptionalInt getSequenceSize() {
        return this.sequenceSize > 0 ? OptionalInt.of(this.sequenceSize) : OptionalInt.empty();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(120);
        buf.append("{");
        buf.append("position=").append(this.getPosition());
        buf.append("; sequenceSize=").append(this.getSequenceSize().isPresent() ? Integer.valueOf(this.getSequenceSize().getAsInt()) : NOT_SET);
        buf.append('}');
        return buf.toString();
    }
}

