/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.message;

import java.util.ServiceLoader;
import org.mule.runtime.api.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleMessageBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMuleMessageBuilderFactory.class);
    private static final AbstractMuleMessageBuilderFactory DEFAULT_FACTORY;

    static final AbstractMuleMessageBuilderFactory getDefaultFactory() {
        return DEFAULT_FACTORY;
    }

    protected abstract Message.PayloadBuilder create();

    protected abstract Message.Builder create(Message var1);

    static {
        try {
            AbstractMuleMessageBuilderFactory factory2 = ServiceLoader.load(AbstractMuleMessageBuilderFactory.class, AbstractMuleMessageBuilderFactory.class.getClassLoader()).iterator().next();
            LOGGER.info(String.format("Loaded MuleMessageBuilderFactory implementation '%s' from classloader '%s'", factory2.getClass().getName(), factory2.getClass().getClassLoader().toString()));
            DEFAULT_FACTORY = factory2;
        }
        catch (Throwable t2) {
            LOGGER.error("Error loading MuleMessageBuilderFactory implementation.", t2);
            throw t2;
        }
    }
}

