/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.deployment.meta;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModel;
import org.mule.runtime.api.deployment.meta.AbstractMuleArtifactModelBuilder;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.deployment.meta.MuleServiceContractModel;
import org.mule.runtime.api.deployment.meta.Product;
import org.mule.runtime.api.util.Preconditions;

@NoExtend
public class MuleServiceModel
extends AbstractMuleArtifactModel {
    private static final String CONTRACT_CLASS_NAME = "contractClassName";
    private static final String SERVICE_PROVIDER_CLASS_NAME = "serviceProviderClassName";
    private final List<MuleServiceContractModel> contracts;

    private MuleServiceModel(String name, String minMuleVersion, Product product, MuleArtifactLoaderDescriptor classLoaderModelLoaderDescriptor, MuleArtifactLoaderDescriptor bundleDescriptorLoader, List<MuleServiceContractModel> contracts) {
        super(name, minMuleVersion, product, classLoaderModelLoaderDescriptor, bundleDescriptorLoader);
        Preconditions.checkArgument(contracts != null && !contracts.isEmpty(), "service must fulfill at least one contract");
        this.contracts = Collections.unmodifiableList(contracts);
    }

    public List<MuleServiceContractModel> getContracts() {
        return this.contracts;
    }

    @Override
    protected void doValidateCustomFields(String descriptorName) {
        Preconditions.checkState(this.contracts != null && !this.contracts.isEmpty(), "Service must fulfill at least one contract");
        this.contracts.forEach(contract -> {
            this.validateMandatoryFieldIsSet(CONTRACT_CLASS_NAME, contract.getContractClassName(), CONTRACT_CLASS_NAME);
            this.validateMandatoryFieldIsSet(SERVICE_PROVIDER_CLASS_NAME, contract.getServiceProviderClassName(), SERVICE_PROVIDER_CLASS_NAME);
        });
    }

    public static class MuleServiceModelBuilder
    extends AbstractMuleArtifactModelBuilder<MuleServiceModelBuilder, MuleServiceModel> {
        private List<MuleServiceContractModel> contracts = Collections.emptyList();

        @Override
        protected MuleServiceModelBuilder getThis() {
            return this;
        }

        public MuleServiceModelBuilder withContracts(List<MuleServiceContractModel> contracts) {
            this.contracts = contracts;
            return this;
        }

        @Override
        public MuleServiceModel build() {
            Preconditions.checkArgument(!StringUtils.isBlank(this.getName()), "name cannot be a blank");
            Preconditions.checkArgument(this.getMinMuleVersion() != null, "minMuleVersion cannot be null");
            Preconditions.checkArgument(this.getBundleDescriptorLoader() != null, "bundleDescriber cannot be null");
            return new MuleServiceModel(this.getName(), this.getMinMuleVersion(), this.getRequiredProduct(), this.getClassLoaderModelDescriptorLoader(), this.getBundleDescriptorLoader(), this.contracts);
        }
    }
}

