/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api;

import java.util.Collection;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.AbstractBuilder;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.WithAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.message.api.DefaultMuleEventMetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataType;

public class MuleEventMetadataTypeBuilder
extends AbstractBuilder<MuleEventMetadataType>
implements WithAnnotation<MuleEventMetadataTypeBuilder> {
    private MessageMetadataType messageMetadataType;
    private MessageMetadataTypeBuilder messageTypeBuilder = new MessageMetadataTypeBuilder();
    private ObjectTypeBuilder variables = new ObjectTypeBuilder(MetadataFormat.JAVA);
    private MetadataType errorType = null;

    public MuleEventMetadataTypeBuilder() {
        super(MetadataFormat.JAVA);
    }

    public MessageMetadataTypeBuilder message() {
        return this.messageTypeBuilder;
    }

    public MuleEventMetadataTypeBuilder message(MessageMetadataTypeBuilder messageTypeBuilder) {
        this.messageTypeBuilder = messageTypeBuilder;
        return this;
    }

    public MuleEventMetadataTypeBuilder message(MessageMetadataType messageMetadataType) {
        this.messageMetadataType = messageMetadataType;
        return this;
    }

    public MuleEventMetadataTypeBuilder error(MetadataType errorType) {
        this.errorType = errorType;
        return this;
    }

    public BaseTypeBuilder addVariable(String name) {
        return this.addVariableField(name).value();
    }

    public MuleEventMetadataTypeBuilder addVariable(String name, MetadataType metadataType) {
        this.addVariableField(name).value(metadataType);
        return this;
    }

    public ObjectFieldTypeBuilder addVariableField(String name) {
        return this.variables.addField().required(true).key(name);
    }

    public static MuleEventMetadataTypeBuilder fromObjectType(ObjectType eventDefinition) {
        MuleEventMetadataTypeBuilder builder = new MuleEventMetadataTypeBuilder();
        Collection<ObjectFieldType> fields = eventDefinition.getFields();
        for (ObjectFieldType field : fields) {
            MetadataType variables;
            if (!field.getKey().isName()) continue;
            String fieldName = field.getKey().getName().getLocalPart();
            if (fieldName.equals("message")) {
                MetadataType messageType = field.getValue();
                if (!(messageType instanceof ObjectType)) continue;
                builder.message(MessageMetadataTypeBuilder.fromObjectType((ObjectType)messageType));
                continue;
            }
            if (fieldName.equals("error")) {
                MetadataType errorType = field.getValue();
                builder.error(errorType);
                continue;
            }
            if (!fieldName.equals("variables") || !((variables = field.getValue()) instanceof ObjectType)) continue;
            Collection<ObjectFieldType> allVariables = ((ObjectType)variables).getFields();
            for (ObjectFieldType variable : allVariables) {
                ObjectFieldTypeBuilder objectFieldTypeBuilder = builder.addVariableField(variable.getKey().getName().getLocalPart());
                objectFieldTypeBuilder.value(variable.getValue());
                variable.getAnnotations().forEach(objectFieldTypeBuilder::with);
            }
        }
        return builder;
    }

    @Override
    public MuleEventMetadataType build() {
        return new DefaultMuleEventMetadataType(this.messageMetadataType != null ? this.messageMetadataType : this.messageTypeBuilder.build(), this.errorType, this.variables.build(), this.annotations);
    }

    @Override
    public MuleEventMetadataTypeBuilder with(TypeAnnotation extension) {
        this.addExtension(extension);
        return this;
    }
}

