/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.api.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class MetadataFormat {
    private final String label;
    private final String id;
    private final Collection<String> validMimeTypes;
    public static MetadataFormat JAVA = new MetadataFormat("Java", "java", "application/java");
    public static MetadataFormat JSON = new MetadataFormat("Json", "json", "application/json");
    public static MetadataFormat XML = new MetadataFormat("XML", "xml", "application/xml");
    public static MetadataFormat CSV = new MetadataFormat("CSV", "csv", "application/csv");

    public MetadataFormat(String label, String id, String ... validMimeTypes) {
        if (StringUtils.isBlank(id)) {
            throw new IllegalArgumentException("id cannot be null");
        }
        this.id = id;
        this.label = label;
        this.validMimeTypes = validMimeTypes != null ? Collections.unmodifiableList(Arrays.asList(validMimeTypes)) : Collections.emptyList();
    }

    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public Collection<String> getValidMimeTypes() {
        return this.validMimeTypes;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MetadataFormat) {
            return Objects.equals(this.id, ((MetadataFormat)obj).id);
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

