/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jackson.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.json.PackageVersion;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.jackson.LocalizationMessages;
import org.glassfish.jersey.jackson.internal.AbstractObjectMapper;
import org.glassfish.jersey.jackson.internal.JaxrsFeatureBag;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.Annotations;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonEndpointConfig;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JsonMapperConfigurator;
import org.glassfish.jersey.message.MessageProperties;

@Singleton
public class DefaultJacksonJaxbJsonProvider
extends JacksonJaxbJsonProvider {
    private Configuration commonConfig;
    private static final Logger LOGGER = Logger.getLogger(DefaultJacksonJaxbJsonProvider.class.getName());
    private final boolean hasConfig;
    private static final String[] EXCLUDE_MODULE_NAMES = new String[]{"JaxbAnnotationModule", "JakartaXmlBindAnnotationModule"};

    @Inject
    public DefaultJacksonJaxbJsonProvider(@Context Providers providers, @Context Configuration config) {
        this(providers, config, DEFAULT_ANNOTATIONS);
    }

    public DefaultJacksonJaxbJsonProvider(Providers providers, Configuration config, Annotations ... annotationsToUse) {
        super(annotationsToUse);
        this.commonConfig = config;
        this._providers = providers;
        boolean ex = true;
        try {
            Object jaxrsFeatureBag = config.getProperty("jersey.config.jackson.jaxrs.feature");
            if (jaxrsFeatureBag != null && JaxrsFeatureBag.class.isInstance(jaxrsFeatureBag)) {
                ((JaxrsFeatureBag)jaxrsFeatureBag).configureJaxrsFeatures(this);
            }
        }
        catch (RuntimeException e) {
            LOGGER.fine(LocalizationMessages.ERROR_CONFIGURING(e.getMessage()));
            ex = false;
        }
        this.hasConfig = ex;
    }

    @Override
    protected ObjectMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        ObjectMapper mapper = super._locateMapperViaProvider(type, mediaType);
        if (AbstractObjectMapper.class.isInstance(mapper)) {
            ((AbstractObjectMapper)mapper).jaxrsFeatureBag.configureJaxrsFeatures(this);
        }
        return mapper;
    }

    @Override
    protected JsonEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        try {
            if (this.hasConfig) {
                this.updateFactoryConstraints(reader.getFactory());
            }
        }
        catch (Throwable t2) {
            LOGGER.warning(LocalizationMessages.ERROR_JACKSON_STREAMREADCONSTRAINTS(t2.getMessage()));
        }
        return super._configForReading(reader, annotations);
    }

    @PostConstruct
    private void findAndRegisterModules() {
        ObjectMapper defaultMapper = ((JsonMapperConfigurator)this._mapperConfig).getDefaultMapper();
        ObjectMapper mapper = ((JsonMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        List<Module> modules = this.filterModules();
        defaultMapper.registerModules(modules);
        if (mapper != null) {
            mapper.registerModules(modules);
        }
    }

    private List<Module> filterModules() {
        List<Module> modules;
        String disabledModules = CommonProperties.getValue(this.commonConfig.getProperties(), this.commonConfig.getRuntimeType(), "jersey.config.json.jackson.disabled.modules", String.class);
        String enabledModules = CommonProperties.getValue(this.commonConfig.getProperties(), this.commonConfig.getRuntimeType(), "jersey.config.json.jackson.enabled.modules", String.class);
        try {
            modules = ObjectMapper.findModules();
        }
        catch (Throwable e) {
            LOGGER.warning(LocalizationMessages.ERROR_MODULES_NOT_LOADED(e.getMessage()));
            return Collections.emptyList();
        }
        for (String exludeModuleName : EXCLUDE_MODULE_NAMES) {
            modules.removeIf(mod -> mod.getModuleName().contains(exludeModuleName));
        }
        if (enabledModules != null && !enabledModules.isEmpty()) {
            List<String> enabledModulesList = Arrays.asList(enabledModules.split(","));
            modules.removeIf(mod -> !enabledModulesList.contains(mod.getModuleName()));
        } else if (disabledModules != null && !disabledModules.isEmpty()) {
            List<String> disabledModulesList = Arrays.asList(disabledModules.split(","));
            modules.removeIf(mod -> disabledModulesList.contains(mod.getModuleName()));
        }
        return modules;
    }

    private void updateFactoryConstraints(JsonFactory jsonFactory) {
        Object maxStringLengthObject = this.commonConfig.getProperty(MessageProperties.JSON_MAX_STRING_LENGTH);
        Integer maxStringLength = PropertiesHelper.convertValue(maxStringLengthObject, Integer.class);
        if (maxStringLength != 20000000) {
            StreamReadConstraints constraints = jsonFactory.streamReadConstraints();
            StreamReadConstraints.Builder builder = StreamReadConstraints.builder().maxStringLength(maxStringLength).maxDocumentLength(constraints.getMaxDocumentLength()).maxNameLength(constraints.getMaxNameLength()).maxNestingDepth(constraints.getMaxNestingDepth()).maxNumberLength(constraints.getMaxNumberLength());
            if (PackageVersion.VERSION.getMinorVersion() >= 18) {
                builder.maxTokenCount(constraints.getMaxTokenCount());
            } else {
                LOGGER.warning(LocalizationMessages.ERROR_JACKSON_STREAMREADCONSTRAINTS_218("maxTokenCount"));
            }
            jsonFactory.setStreamReadConstraints(builder.build());
        }
    }
}

