/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.innate.inject;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.ws.rs.ConstrainedTo;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.client.innate.inject.NonInjectionRequestScope;
import org.glassfish.jersey.client.internal.LocalizationMessages;
import org.glassfish.jersey.internal.inject.AbstractBinder;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.ClassBinding;
import org.glassfish.jersey.internal.inject.DisposableSupplier;
import org.glassfish.jersey.internal.inject.ForeignDescriptor;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.InstanceBinding;
import org.glassfish.jersey.internal.inject.PerThread;
import org.glassfish.jersey.internal.inject.ServiceHolder;
import org.glassfish.jersey.internal.inject.ServiceHolderImpl;
import org.glassfish.jersey.internal.inject.SupplierClassBinding;
import org.glassfish.jersey.internal.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.util.collection.LazyValue;
import org.glassfish.jersey.internal.util.collection.Values;
import org.glassfish.jersey.process.internal.RequestScope;
import org.glassfish.jersey.process.internal.RequestScoped;

@ConstrainedTo(value=RuntimeType.CLIENT)
public final class NonInjectionManager
implements InjectionManager {
    private static final Logger logger = Logger.getLogger(NonInjectionManager.class.getName());
    private final MultivaluedMap<Class<?>, InstanceBinding<?>> instanceBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Class<?>, ClassBinding<?>> contractBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Class<?>, SupplierInstanceBinding<?>> supplierInstanceBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Class<?>, SupplierClassBinding<?>> supplierClassBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Type, InstanceBinding<?>> instanceTypeBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Type, ClassBinding<?>> contractTypeBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Type, SupplierInstanceBinding<?>> supplierTypeInstanceBindings = new MultivaluedHashMap();
    private final MultivaluedMap<Type, SupplierClassBinding<?>> supplierTypeClassBindings = new MultivaluedHashMap();
    private final Instances instances = new Instances();
    private final Types types = new Types();
    private volatile boolean isRequestScope = false;
    private volatile boolean shutdown = false;

    public NonInjectionManager() {
        Binding binding = new AbstractBinder(){

            @Override
            protected void configure() {
                ((ClassBinding)this.bind(NonInjectionRequestScope.class).to(RequestScope.class)).in(Singleton.class);
            }
        }.getBindings().iterator().next();
        NonInjectionRequestScope scope = new NonInjectionRequestScope(this);
        this.instances.addSingleton(RequestScope.class, scope, binding, null);
        this.types.addSingleton(RequestScope.class, scope, binding, null);
    }

    public NonInjectionManager(boolean warning) {
        this();
        if (warning) {
            logger.warning(LocalizationMessages.NONINJECT_FALLBACK());
        } else {
            logger.log(Level.FINER, LocalizationMessages.NONINJECT_FALLBACK());
        }
    }

    @Override
    public void completeRegistration() {
        this.instances._addSingleton(InjectionManager.class, this, new InjectionManagerBinding(), null, false);
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
        this.instances.dispose();
        this.types.dispose();
    }

    void disposeRequestScopedInstances() {
        this.instances.disposeThreadInstances(false);
        this.types.disposeThreadInstances(false);
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    private void checkShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException(LocalizationMessages.NONINJECT_SHUTDOWN());
        }
    }

    @Override
    public void register(Binding binding) {
        block11: {
            block13: {
                block12: {
                    block10: {
                        this.checkShutdown();
                        if (!InstanceBinding.class.isInstance(binding)) break block10;
                        InstanceBinding instanceBinding = (InstanceBinding)binding;
                        Class mainType = binding.getImplementationType();
                        if (!this.instanceBindings.containsKey(mainType)) {
                            this.instanceBindings.add(mainType, (InstanceBinding)binding);
                        }
                        for (Type type : instanceBinding.getContracts()) {
                            if (NonInjectionManager.isClass(type)) {
                                if (mainType.equals(type)) continue;
                                this.instanceBindings.add((Class)type, instanceBinding);
                                continue;
                            }
                            this.instanceTypeBindings.add(type, instanceBinding);
                        }
                        break block11;
                    }
                    if (!ClassBinding.class.isInstance(binding)) break block12;
                    ClassBinding contractBinding = (ClassBinding)binding;
                    Class mainType = binding.getImplementationType();
                    if (!this.contractBindings.containsKey(mainType)) {
                        this.contractBindings.add(mainType, contractBinding);
                    }
                    for (Type type : contractBinding.getContracts()) {
                        if (NonInjectionManager.isClass(type)) {
                            if (mainType.equals(type)) continue;
                            this.contractBindings.add((Class)type, contractBinding);
                            continue;
                        }
                        this.contractTypeBindings.add(type, contractBinding);
                    }
                    break block11;
                }
                if (!SupplierInstanceBinding.class.isInstance(binding)) break block13;
                SupplierInstanceBinding supplierBinding = (SupplierInstanceBinding)binding;
                for (Type type : supplierBinding.getContracts()) {
                    if (NonInjectionManager.isClass(type)) {
                        this.supplierInstanceBindings.add((Class)type, supplierBinding);
                        continue;
                    }
                    this.supplierTypeInstanceBindings.add(type, supplierBinding);
                }
                break block11;
            }
            if (!SupplierClassBinding.class.isInstance(binding)) break block11;
            SupplierClassBinding supplierBinding = (SupplierClassBinding)binding;
            for (Type type : supplierBinding.getContracts()) {
                if (NonInjectionManager.isClass(type)) {
                    this.supplierClassBindings.add((Class)type, supplierBinding);
                    continue;
                }
                this.supplierTypeClassBindings.add(type, supplierBinding);
            }
        }
    }

    @Override
    public void register(Iterable<Binding> descriptors) {
        this.checkShutdown();
        for (Binding binding : descriptors) {
            this.register(binding);
        }
    }

    @Override
    public void register(Binder binder) {
        this.checkShutdown();
        binder.getBindings().stream().iterator().forEachRemaining(this::register);
    }

    @Override
    public void register(Object provider) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Register " + provider);
    }

    @Override
    public boolean isRegistrable(Class<?> clazz) {
        return false;
    }

    @Override
    public <T> List<ServiceHolder<T>> getAllServiceHolders(Class<T> contractOrImpl, Annotation ... qualifiers) {
        this.checkShutdown();
        ClassBindings<T> classBindings = this.classBindings(contractOrImpl, qualifiers);
        return classBindings.getAllServiceHolders(qualifiers);
    }

    @Override
    public <T> T getInstance(Class<T> contractOrImpl, Annotation ... qualifiers) {
        this.checkShutdown();
        ClassBindings<T> classBindings = this.classBindings(contractOrImpl, qualifiers);
        classBindings.matchQualifiers(qualifiers);
        return (T)classBindings.getInstance();
    }

    @Override
    public <T> T getInstance(Class<T> contractOrImpl, String classAnalyzer) {
        throw new UnsupportedOperationException("getInstance(Class, String)");
    }

    @Override
    public <T> T getInstance(Class<T> contractOrImpl) {
        this.checkShutdown();
        Object instance = this.instances.getInstance(contractOrImpl, null);
        if (instance != null) {
            return instance;
        }
        return this.create(contractOrImpl);
    }

    @Override
    public <T> T getInstance(Type contractOrImpl) {
        this.checkShutdown();
        if (ParameterizedType.class.isInstance(contractOrImpl)) {
            Object instance = this.types.getInstance(contractOrImpl, null);
            if (instance != null) {
                return instance;
            }
            TypeBindings<T> typeBindings = this.typeBindings(contractOrImpl);
            return (T)typeBindings.getInstance();
        }
        if (NonInjectionManager.isClass(contractOrImpl)) {
            return this.getInstance((Class)contractOrImpl);
        }
        throw new IllegalStateException(LocalizationMessages.NONINJECT_UNSATISFIED(contractOrImpl));
    }

    private static boolean isClass(Type type) {
        return Class.class.isAssignableFrom(type.getClass());
    }

    @Override
    public Object getInstance(ForeignDescriptor foreignDescriptor) {
        throw new UnsupportedOperationException("getInstance(ForeignDescriptor foreignDescriptor) ");
    }

    @Override
    public ForeignDescriptor createForeignDescriptor(Binding binding) {
        throw new UnsupportedOperationException("createForeignDescriptor(Binding binding) ");
    }

    @Override
    public <T> List<T> getAllInstances(Type contractOrImpl) {
        this.checkShutdown();
        if (!NonInjectionManager.isClass(contractOrImpl)) {
            TypeBindings<T> typeBindings = this.typeBindings(contractOrImpl);
            return typeBindings.allInstances();
        }
        ClassBindings<T> classBindings = this.classBindings((Class)contractOrImpl, new Annotation[0]);
        return classBindings.allInstances();
    }

    @Override
    public <T> T create(Class<T> createMe) {
        this.checkShutdown();
        if (InjectionManager.class.equals(createMe)) {
            return (T)this;
        }
        if (RequestScope.class.equals(createMe)) {
            throw new IllegalStateException(LocalizationMessages.NONINJECT_REQUESTSCOPE_CREATED());
        }
        ClassBindings<T> classBindings = this.classBindings(createMe, new Annotation[0]);
        return (T)classBindings.create(true);
    }

    @Override
    public <T> T createAndInitialize(Class<T> createMe) {
        this.checkShutdown();
        if (InjectionManager.class.equals(createMe)) {
            return (T)this;
        }
        if (RequestScope.class.equals(createMe)) {
            throw new IllegalStateException(LocalizationMessages.NONINJECT_REQUESTSCOPE_CREATED());
        }
        ClassBindings<T> classBindings = this.classBindings(createMe, new Annotation[0]);
        Object t2 = classBindings.create(false);
        return (T)(t2 != null ? t2 : this.justCreate(createMe));
    }

    public <T> T justCreate(Class<T> createMe) {
        T result = null;
        try {
            Constructor<T> mostArgConstructor = NonInjectionManager.findConstructor(createMe);
            if (mostArgConstructor != null) {
                Object[] args2;
                int argCount = mostArgConstructor.getParameterCount();
                if (argCount == 0) {
                    NonInjectionManager.ensureAccessible(mostArgConstructor);
                    result = mostArgConstructor.newInstance(new Object[0]);
                } else if (argCount > 0 && (args2 = this.getArguments(mostArgConstructor, argCount)) != null) {
                    NonInjectionManager.ensureAccessible(mostArgConstructor);
                    result = mostArgConstructor.newInstance(args2);
                }
            }
            if (result == null) {
                throw new IllegalStateException(LocalizationMessages.NONINJECT_NO_CONSTRUCTOR(createMe.getName()));
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        this.inject(result);
        return result;
    }

    private static <T> Constructor<T> findConstructor(Class<T> forClass) {
        Constructor<?>[] constructors = forClass.getDeclaredConstructors();
        Constructor<?> mostArgConstructor = null;
        int argCount = -1;
        for (Constructor<?> constructor : constructors) {
            if (!constructor.isAnnotationPresent(Inject.class) && constructor.getParameterCount() != 0 || constructor.getParameterCount() <= argCount) continue;
            mostArgConstructor = constructor;
            argCount = constructor.getParameterCount();
        }
        return mostArgConstructor;
    }

    private Object[] getArguments(Executable executable, int argCount) {
        if (executable == null) {
            return null;
        }
        Object[] args2 = new Object[argCount];
        for (int i = 0; i != argCount; ++i) {
            Type type = executable.getAnnotatedParameterTypes()[i].getType();
            args2[i] = NonInjectionManager.isClass(type) ? this.getInstance((Class)type) : this.getInstance(type);
        }
        return args2;
    }

    private static void ensureAccessible(Executable executable) {
        try {
            if (!executable.isAccessible()) {
                executable.setAccessible(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void checkUnique(List<?> list) {
        if (list.size() != 1) {
            throw new IllegalStateException(LocalizationMessages.NONINJECT_AMBIGUOUS_SERVICES(list.get(0)));
        }
    }

    @Override
    public void inject(Object injectMe) {
        Method postConstruct = NonInjectionManager.getAnnotatedMethod(injectMe, PostConstruct.class);
        if (postConstruct != null) {
            NonInjectionManager.ensureAccessible(postConstruct);
            try {
                postConstruct.invoke(injectMe, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Override
    public void inject(Object injectMe, String classAnalyzer) {
        throw new UnsupportedOperationException("inject(Object injectMe, String classAnalyzer)");
    }

    @Override
    public void preDestroy(Object preDestroyMe) {
        Method preDestroy;
        Method method = preDestroy = Method.class.isInstance(preDestroyMe) ? (Method)preDestroyMe : NonInjectionManager.getAnnotatedMethod(preDestroyMe, PreDestroy.class);
        if (preDestroy != null) {
            NonInjectionManager.ensureAccessible(preDestroy);
            try {
                preDestroy.invoke(preDestroyMe, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static Method getAnnotatedMethod(Object object, Class<? extends Annotation> annotation) {
        Class<?> clazz = object.getClass();
        for (Method method : clazz.getMethods()) {
            if (!method.isAnnotationPresent(annotation) || method.getParameterCount() != 0) continue;
            return method;
        }
        return null;
    }

    private <T> T createSupplierProxyIfNeeded(Boolean createProxy, Class<T> iface, final Supplier<Supplier<T>> supplier, final TypedInstances<?> typedInstances) {
        if (createProxy != null && createProxy.booleanValue() && iface.isInterface()) {
            Object proxy = Proxy.newProxyInstance(iface.getClassLoader(), new Class[]{iface}, new InvocationHandler(){
                final Set<Object> instances = new HashSet<Object>();

                @Override
                public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
                    Supplier supplierT = (Supplier)supplier.get();
                    Object t2 = supplierT.get();
                    if (DisposableSupplier.class.isInstance(supplierT) && !this.instances.contains(t2)) {
                        MultivaluedMap map = (MultivaluedMap)typedInstances.disposableSupplierObjects.get();
                        map.add((DisposableSupplier)supplierT, t2);
                    }
                    Object ret = method.invoke(t2, args2);
                    return ret;
                }
            });
            return (T)proxy;
        }
        return this.registerDisposableSupplierAndGet(supplier.get(), typedInstances);
    }

    private <T> T registerDisposableSupplierAndGet(Supplier<T> supplier, TypedInstances<?> typedInstances) {
        T instance = supplier.get();
        if (DisposableSupplier.class.isInstance(supplier)) {
            ((MultivaluedMap)((TypedInstances)typedInstances).disposableSupplierObjects.get()).add((DisposableSupplier)supplier, instance);
        }
        return instance;
    }

    private <T> ClassBindings<T> classBindings(Class<T> clazz, Annotation ... instancesQualifiers) {
        List scb;
        List cb;
        List sib;
        ClassBindings classBindings = new ClassBindings(clazz, instancesQualifiers);
        List ib = (List)this.instanceBindings.get(clazz);
        if (ib != null) {
            ib.forEach(binding -> classBindings.instanceBindings.add(binding));
        }
        if ((sib = (List)this.supplierInstanceBindings.get(clazz)) != null) {
            sib.forEach(binding -> classBindings.supplierInstanceBindings.add(binding));
        }
        if ((cb = (List)this.contractBindings.get(clazz)) != null) {
            cb.forEach(binding -> classBindings.classBindings.add(binding));
        }
        if ((scb = (List)this.supplierClassBindings.get(clazz)) != null) {
            scb.forEach(binding -> classBindings.supplierClassBindings.add(binding));
        }
        return classBindings;
    }

    private <T> TypeBindings<T> typeBindings(Type type) {
        List scb;
        List cb;
        List sib;
        TypeBindings typeBindings = new TypeBindings(type);
        List ib = (List)this.instanceTypeBindings.get(type);
        if (ib != null) {
            ib.forEach(binding -> typeBindings.instanceBindings.add(binding));
        }
        if ((sib = (List)this.supplierTypeInstanceBindings.get(type)) != null) {
            sib.forEach(binding -> typeBindings.supplierInstanceBindings.add(binding));
        }
        if ((cb = (List)this.contractTypeBindings.get(type)) != null) {
            cb.forEach(binding -> typeBindings.classBindings.add(binding));
        }
        if ((scb = (List)this.supplierTypeClassBindings.get(type)) != null) {
            scb.forEach(binding -> typeBindings.supplierClassBindings.add(binding));
        }
        return typeBindings;
    }

    private static final class InjectionManagerBinding
    extends Binding<InjectionManager, Binding<?, ?>> {
        private InjectionManagerBinding() {
        }
    }

    private static class InstanceContext<T> {
        private final T instance;
        private final Binding<?, ?> binding;
        private final Annotation[] createdWithQualifiers;
        private boolean destroyed = false;

        private InstanceContext(T instance, Binding<?, ?> binding, Annotation[] qualifiers, boolean destroyed) {
            this.instance = instance;
            this.binding = binding;
            this.createdWithQualifiers = qualifiers;
            this.destroyed = destroyed;
        }

        public Binding<?, ?> getBinding() {
            return this.binding;
        }

        public T getInstance() {
            return this.instance;
        }

        public void destroy(NonInjectionManager nonInjectionManager) {
            if (!this.destroyed) {
                this.destroyed = true;
                nonInjectionManager.preDestroy(this.instance);
            }
        }

        static <T> List<T> toInstances(List<InstanceContext<?>> instances, Annotation[] qualifiers) {
            return instances != null ? instances.stream().filter(instance -> instance.hasQualifiers(qualifiers)).map(pair -> pair.getInstance()).collect(Collectors.toList()) : null;
        }

        private static List<InstanceContext<?>> filterInstances(List<InstanceContext<?>> instances, Annotation ... qualifiers) {
            return instances != null ? instances.stream().filter(instance -> instance.hasQualifiers(qualifiers)).collect(Collectors.toList()) : null;
        }

        private static List<InstanceContext<?>> merge(List<InstanceContext<?>> i1, List<InstanceContext<?>> i2) {
            if (i1 == null) {
                i1 = i2;
            } else if (i2 != null) {
                i1.addAll(i2);
            }
            return i1;
        }

        private boolean hasQualifiers(Annotation[] requested) {
            if (requested != null) {
                block0: for (Annotation req : requested) {
                    if (this.createdWithQualifiers == null) continue;
                    for (Annotation cur : this.createdWithQualifiers) {
                        if (cur.annotationType().isInstance(req)) continue block0;
                    }
                    return false;
                }
            }
            return true;
        }
    }

    private class TypeBindings<T>
    extends XBindings<T, Type> {
        private TypeBindings(Type type) {
            super(NonInjectionManager.this, type, null, (TypedInstances)NonInjectionManager.this.types);
        }

        @Override
        protected T _create(SupplierClassBinding<T> binding) {
            Supplier<T> supplier = NonInjectionManager.this.justCreate(binding.getSupplierClass());
            Object t2 = NonInjectionManager.this.registerDisposableSupplierAndGet(supplier, this.instances);
            t2 = this.addInstance(this.type, t2, binding);
            return (T)t2;
        }

        @Override
        protected T _createAndStore(ClassBinding<T> binding) {
            T result = NonInjectionManager.this.justCreate(binding.getService());
            result = this.addInstance(this.type, result, binding);
            return result;
        }

        @Override
        T create(boolean throwWhenNoBinding) {
            ParameterizedType pt;
            if (ParameterizedType.class.isInstance(this.type) && Provider.class.equals((Object)(pt = (ParameterizedType)this.type).getRawType())) {
                return (T)new Provider<Object>(){
                    final SingleRegisterSupplier<Object> supplier;
                    {
                        this.supplier = new SingleRegisterSupplier(new Supplier<Object>(){

                            @Override
                            public Object get() {
                                Type actualTypeArgument = pt.getActualTypeArguments()[0];
                                if (NonInjectionManager.isClass(actualTypeArgument)) {
                                    return NonInjectionManager.this.getInstance((Class)actualTypeArgument);
                                }
                                return NonInjectionManager.this.getInstance(actualTypeArgument);
                            }
                        }, TypeBindings.this.instances);
                    }

                    @Override
                    public Object get() {
                        return this.supplier.get();
                    }
                };
            }
            return (T)super.create(throwWhenNoBinding);
        }
    }

    private class ClassBindings<T>
    extends XBindings<T, Class<?>> {
        private ClassBindings(Class<T> clazz, Annotation[] instancesQualifiers) {
            super(NonInjectionManager.this, clazz, instancesQualifiers, (TypedInstances)NonInjectionManager.this.instances);
        }

        List<ServiceHolder<T>> getAllServiceHolders(Annotation ... qualifiers) {
            this.matchQualifiers(qualifiers);
            LinkedList holders = new LinkedList();
            List<InstanceContext<?>> instanceContextList = this.instances.getContexts(this.type, qualifiers);
            if (instanceContextList != null) {
                instanceContextList.forEach(instanceContext -> this.filterBinding(instanceContext.getBinding()));
                instanceContextList.forEach(instanceContext -> holders.add(new ServiceHolderImpl(instanceContext.getInstance(), instanceContext.getInstance().getClass(), instanceContext.getBinding().getContracts(), instanceContext.getBinding().getRank() == null ? 0 : instanceContext.getBinding().getRank())));
            }
            List instanceBindingHolders = this.instanceBindings.stream().map(this::_serviceHolder).collect(Collectors.toList());
            holders.addAll(instanceBindingHolders);
            List classBindingHolders = this.classBindings.stream().filter(binding -> NonInjectionManager.findConstructor(binding.getService()) != null).map(this::_serviceHolder).collect(Collectors.toList());
            holders.addAll(classBindingHolders);
            return holders;
        }

        private <T> ServiceHolderImpl<T> _serviceHolder(InstanceBinding<T> binding) {
            return new ServiceHolderImpl<T>(binding.getService(), binding.getImplementationType(), binding.getContracts(), binding.getRank() == null ? 0 : binding.getRank());
        }

        private <T> ServiceHolderImpl<T> _serviceHolder(ClassBinding<T> binding) {
            return new ServiceHolderImpl<T>(NonInjectionManager.this.create(binding.getService()), binding.getImplementationType(), binding.getContracts(), binding.getRank() == null ? 0 : binding.getRank());
        }

        @Override
        protected T _create(SupplierClassBinding<T> binding) {
            Supplier<Supplier> supplierSupplier = () -> {
                Supplier supplier = (Supplier)this.instances.getInstance(binding.getSupplierClass(), null);
                if (supplier == null) {
                    supplier = NonInjectionManager.this.justCreate(binding.getSupplierClass());
                    if (Singleton.class.equals(binding.getSupplierScope())) {
                        supplier = this.instances.addSingleton(binding.getSupplierClass(), supplier, binding, null);
                    } else if (this._isPerThread(binding.getSupplierScope()) || binding.getSupplierScope() == null) {
                        this.instances.addThreadInstance(binding.getSupplierClass(), supplier, binding, null);
                    }
                }
                return supplier;
            };
            Object t2 = NonInjectionManager.this.createSupplierProxyIfNeeded(binding.isProxiable(), (Class)this.type, supplierSupplier, this.instances);
            return (T)t2;
        }

        @Override
        protected T _createAndStore(ClassBinding<T> binding) {
            T result = NonInjectionManager.this.justCreate(binding.getService());
            result = this.addInstance(binding.getService(), result, binding);
            return result;
        }
    }

    private static abstract class XBindings<X, TYPE extends Type> {
        protected final List<InstanceBinding<X>> instanceBindings = new LinkedList<InstanceBinding<X>>();
        protected final List<SupplierInstanceBinding<X>> supplierInstanceBindings = new LinkedList<SupplierInstanceBinding<X>>();
        protected final List<ClassBinding<X>> classBindings = new LinkedList<ClassBinding<X>>();
        protected final List<SupplierClassBinding<X>> supplierClassBindings = new LinkedList<SupplierClassBinding<X>>();
        protected final TYPE type;
        protected final Annotation[] instancesQualifiers;
        protected final TypedInstances<TYPE> instances;
        final /* synthetic */ NonInjectionManager this$0;

        protected XBindings(TYPE type, Annotation[] instancesQualifiers, TypedInstances<TYPE> instances) {
            this.this$0 = var1_1;
            this.type = type;
            this.instancesQualifiers = instancesQualifiers;
            this.instances = instances;
        }

        int size() {
            return this.instanceBindings.size() + this.supplierInstanceBindings.size() + this.classBindings.size() + this.supplierClassBindings.size();
        }

        private void _checkUnique() {
            if (this.size() > 1) {
                throw new IllegalStateException(LocalizationMessages.NONINJECT_AMBIGUOUS_SERVICES(this.type));
            }
        }

        void filterBinding(Binding binding) {
            if (InstanceBinding.class.isInstance(binding)) {
                this.instanceBindings.remove(binding);
            } else if (ClassBinding.class.isInstance(binding)) {
                this.classBindings.remove(binding);
            } else if (SupplierInstanceBinding.class.isInstance(binding)) {
                this.supplierInstanceBindings.remove(binding);
            } else if (SupplierClassBinding.class.isInstance(binding)) {
                this.supplierClassBindings.remove(binding);
            }
        }

        void matchQualifiers(Annotation ... bindingQualifiers) {
            if (bindingQualifiers != null) {
                this._filterRequested(this.instanceBindings, bindingQualifiers);
                this._filterRequested(this.classBindings, bindingQualifiers);
                this._filterRequested(this.supplierInstanceBindings, bindingQualifiers);
                this._filterRequested(this.supplierClassBindings, bindingQualifiers);
            }
        }

        private void _filterRequested(List<? extends Binding<?, ?>> bindingList, Annotation ... requestedQualifiers) {
            Iterator<Binding<?, ?>> bindingIterator = bindingList.iterator();
            while (bindingIterator.hasNext()) {
                Binding<?, ?> binding = bindingIterator.next();
                block1: for (Annotation requestedQualifier : requestedQualifiers) {
                    for (Annotation bindingQualifier : binding.getQualifiers()) {
                        if (!requestedQualifier.annotationType().isInstance(bindingQualifier)) continue;
                        continue block1;
                    }
                    bindingIterator.remove();
                }
            }
        }

        protected boolean _isPerThread(Class<? extends Annotation> scope) {
            return RequestScoped.class.equals(scope) || PerThread.class.equals(scope);
        }

        private X _getInstance(InstanceBinding<X> instanceBinding) {
            return instanceBinding.getService();
        }

        private X _create(SupplierInstanceBinding<X> binding) {
            Supplier<X> supplier = binding.getSupplier();
            Object t2 = this.this$0.registerDisposableSupplierAndGet(supplier, this.instances);
            t2 = this.addInstance(this.type, t2, binding);
            return (X)t2;
        }

        X create(boolean throwWhenNoBinding) {
            this._checkUnique();
            if (!this.instanceBindings.isEmpty()) {
                return this._getInstance(this.instanceBindings.get(0));
            }
            if (!this.supplierInstanceBindings.isEmpty()) {
                return this._create(this.supplierInstanceBindings.get(0));
            }
            if (!this.classBindings.isEmpty()) {
                return this._createAndStore(this.classBindings.get(0));
            }
            if (!this.supplierClassBindings.isEmpty()) {
                return this._create(this.supplierClassBindings.get(0));
            }
            if (throwWhenNoBinding) {
                throw new IllegalStateException(LocalizationMessages.NONINJECT_NO_BINDING(this.type));
            }
            return null;
        }

        protected X getInstance() {
            Object instance = this.instances.getInstance(this.type, this.instancesQualifiers);
            if (instance != null) {
                return (X)instance;
            }
            return this.create(true);
        }

        List<X> allInstances() {
            LinkedList list = new LinkedList();
            List<InstanceContext<?>> instanceContextList = this.instances.getContexts(this.type, this.instancesQualifiers);
            if (instanceContextList != null) {
                instanceContextList.forEach(instanceContext -> this.filterBinding(instanceContext.getBinding()));
                instanceContextList.forEach(instanceContext -> list.add(instanceContext.getInstance()));
            }
            list.addAll(this.instanceBindings.stream().map(this::_getInstance).collect(Collectors.toList()));
            list.addAll(this.classBindings.stream().map(this::_createAndStore).collect(Collectors.toList()));
            list.addAll(this.supplierInstanceBindings.stream().map(this::_create).collect(Collectors.toList()));
            list.addAll(this.supplierClassBindings.stream().map(this::_create).collect(Collectors.toList()));
            return list;
        }

        protected abstract X _create(SupplierClassBinding<X> var1);

        protected abstract X _createAndStore(ClassBinding<X> var1);

        protected <T> T _addSingletonInstance(TYPE type, T instance, Binding<?, ?> binding) {
            return this.instances.addSingleton(type, instance, binding, this.instancesQualifiers);
        }

        protected <T> T addInstance(TYPE type, T instance, Binding binding) {
            if (Singleton.class.equals(binding.getScope())) {
                instance = this.instances.addSingleton(type, instance, binding, this.instancesQualifiers);
            } else if (this._isPerThread(binding.getScope())) {
                this.instances.addThreadInstance(type, instance, binding, this.instancesQualifiers);
            }
            return instance;
        }
    }

    private class SingleRegisterSupplier<T> {
        private final LazyValue<T> once = Values.lazy(() -> NonInjectionManager.access$800(NonInjectionManager.this, supplier, instances));

        private SingleRegisterSupplier(Supplier<T> supplier, TypedInstances<?> instances) {
        }

        T get() {
            return this.once.get();
        }
    }

    private class Types
    extends TypedInstances<Type> {
        private Types() {
        }
    }

    private class Instances
    extends TypedInstances<Class<?>> {
        private Instances() {
        }
    }

    private class TypedInstances<TYPE extends Type> {
        private final MultivaluedMap<TYPE, InstanceContext<?>> singletonInstances = new MultivaluedHashMap();
        private ThreadLocal<MultivaluedMap<TYPE, InstanceContext<?>>> threadInstances = new ThreadLocal();
        private ThreadLocal<MultivaluedMap<DisposableSupplier, Object>> disposableSupplierObjects = ThreadLocal.withInitial(() -> new MultivaluedHashMap());

        private TypedInstances() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> List<InstanceContext<?>> _getSingletons(TYPE clazz) {
            List si;
            MultivaluedMap<TYPE, InstanceContext<?>> multivaluedMap = this.singletonInstances;
            synchronized (multivaluedMap) {
                si = (List)this.singletonInstances.get(clazz);
            }
            return si;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <T> T _addSingleton(TYPE clazz, T instance, Binding<?, ?> binding, Annotation[] qualifiers, boolean destroy) {
            MultivaluedMap<TYPE, InstanceContext<?>> multivaluedMap = this.singletonInstances;
            synchronized (multivaluedMap) {
                List qualified;
                List values2 = (List)this.singletonInstances.get(clazz);
                if (values2 != null && !(qualified = values2.stream().filter(ctx -> ((InstanceContext)ctx).hasQualifiers(qualifiers)).collect(Collectors.toList())).isEmpty()) {
                    return (T)((InstanceContext)qualified.get(0)).instance;
                }
                InstanceContext instanceContext = new InstanceContext(instance, binding, qualifiers, !destroy);
                this.singletonInstances.add(clazz, instanceContext);
                return instance;
            }
        }

        <T> T addSingleton(TYPE clazz, T t2, Binding<?, ?> binding, Annotation[] instanceQualifiers) {
            T t22 = this._addSingleton(clazz, t2, binding, instanceQualifiers, true);
            if (t22 == t2) {
                for (Type contract : binding.getContracts()) {
                    if (clazz.equals(contract) || !NonInjectionManager.isClass(contract)) continue;
                    this._addSingleton(contract, t2, binding, instanceQualifiers, false);
                }
            }
            return t22;
        }

        private List<InstanceContext<?>> _getThreadInstances(TYPE clazz) {
            LinkedList list;
            MultivaluedMap<TYPE, InstanceContext<?>> ti = this.threadInstances.get();
            LinkedList linkedList = list = ti == null ? null : new LinkedList();
            if (ti != null) {
                return (List)ti.get(clazz);
            }
            return list;
        }

        private <T> void _addThreadInstance(TYPE clazz, T instance, Binding<T, ?> binding, Annotation[] qualifiers, boolean destroy) {
            MultivaluedMap<TYPE, InstanceContext<?>> map = this.threadInstances.get();
            if (map == null) {
                map = new MultivaluedHashMap();
                this.threadInstances.set(map);
            }
            InstanceContext instanceContext = new InstanceContext(instance, binding, qualifiers, !destroy);
            map.add(clazz, instanceContext);
        }

        <T> void addThreadInstance(TYPE clazz, T t2, Binding<T, ?> binding, Annotation[] instanceQualifiers) {
            this._addThreadInstance(clazz, t2, binding, instanceQualifiers, true);
            for (Type contract : binding.getContracts()) {
                if (clazz.equals(contract) || !NonInjectionManager.isClass(contract)) continue;
                this._addThreadInstance(contract, t2, binding, instanceQualifiers, false);
            }
        }

        private <T> List<T> getInstances(TYPE clazz, Annotation[] annotations) {
            List<InstanceContext<?>> i = this._getContexts(clazz);
            return InstanceContext.toInstances(i, annotations);
        }

        <T> List<InstanceContext<?>> getContexts(TYPE clazz, Annotation[] annotations) {
            List<InstanceContext<?>> i = this._getContexts(clazz);
            return InstanceContext.filterInstances(i, annotations);
        }

        private <T> List<InstanceContext<?>> _getContexts(TYPE clazz) {
            List<InstanceContext<?>> si = this._getSingletons(clazz);
            List<InstanceContext<?>> ti = this._getThreadInstances(clazz);
            return InstanceContext.merge(si, ti);
        }

        <T> T getInstance(TYPE clazz, Annotation[] annotations) {
            List<T> i = this.getInstances(clazz, annotations);
            if (i != null) {
                NonInjectionManager.this.checkUnique(i);
                return this.instanceOrSupply(clazz, i.get(0));
            }
            return null;
        }

        private <T> T instanceOrSupply(TYPE clazz, T t2) {
            if (!Class.class.isInstance(clazz) || ((Class)clazz).isInstance(t2)) {
                return t2;
            }
            if (Supplier.class.isInstance(t2)) {
                return (T)NonInjectionManager.this.registerDisposableSupplierAndGet((Supplier)t2, this);
            }
            if (Provider.class.isInstance(t2)) {
                return ((Provider)t2).get();
            }
            return t2;
        }

        void dispose() {
            this.singletonInstances.forEach((clazz, instances) -> instances.forEach(instance -> NonInjectionManager.this.preDestroy(instance.getInstance())));
            this.disposeThreadInstances(true);
            this.threadInstances = null;
            this.disposableSupplierObjects = null;
        }

        void disposeThreadInstances(boolean allThreadInstances) {
            MultivaluedMap<TYPE, InstanceContext<?>> ti = this.threadInstances.get();
            if (ti == null) {
                return;
            }
            Set tiSet = ti.entrySet();
            Iterator tiSetIt = tiSet.iterator();
            while (tiSetIt.hasNext()) {
                Map.Entry entry = tiSetIt.next();
                Iterator listIt = ((List)entry.getValue()).iterator();
                while (listIt.hasNext()) {
                    InstanceContext instanceContext = (InstanceContext)listIt.next();
                    if (allThreadInstances || instanceContext.getBinding().getScope() != PerThread.class) {
                        listIt.remove();
                        if (DisposableSupplier.class.isInstance(instanceContext.getInstance())) {
                            MultivaluedMap<DisposableSupplier, Object> disposeMap = this.disposableSupplierObjects.get();
                            Iterator disposeMapIt = disposeMap.entrySet().iterator();
                            while (disposeMapIt.hasNext()) {
                                Map.Entry disposeMapEntry = disposeMapIt.next();
                                if (disposeMapEntry.getKey() == instanceContext.getInstance()) {
                                    Iterator disposeMapEntryIt = ((List)disposeMapEntry.getValue()).iterator();
                                    while (disposeMapEntryIt.hasNext()) {
                                        Object disposeInstance = disposeMapEntryIt.next();
                                        ((DisposableSupplier)instanceContext.getInstance()).dispose(disposeInstance);
                                        disposeMapEntryIt.remove();
                                    }
                                }
                                if (!((List)disposeMapEntry.getValue()).isEmpty()) continue;
                                disposeMapIt.remove();
                            }
                        }
                        instanceContext.destroy(NonInjectionManager.this);
                    }
                    if (!((List)entry.getValue()).isEmpty()) continue;
                    tiSetIt.remove();
                }
            }
            this.disposableSupplierObjects.remove();
        }
    }
}

