/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler;

import com.typesafe.netty.HandlerPublisher;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamedResponsePublisher
extends HandlerPublisher<HttpResponseBodyPart> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ChannelManager channelManager;
    private final NettyResponseFuture<?> future;
    private final Channel channel;
    private volatile boolean hasOutstandingRequest = false;
    private Throwable error;

    StreamedResponsePublisher(EventExecutor executor, ChannelManager channelManager, NettyResponseFuture<?> future, Channel channel) {
        super(executor, HttpResponseBodyPart.class);
        this.channelManager = channelManager;
        this.future = future;
        this.channel = channel;
    }

    @Override
    protected void cancelled() {
        this.logger.debug("Subscriber cancelled, ignoring the rest of the body");
        try {
            this.future.done();
        }
        catch (Exception t2) {
            this.logger.debug(t2.getMessage(), t2);
        }
        this.channelManager.closeChannel(this.channel);
    }

    @Override
    protected void requestDemand() {
        this.hasOutstandingRequest = true;
        super.requestDemand();
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.hasOutstandingRequest = false;
        super.channelReadComplete(ctx);
    }

    @Override
    public void subscribe(Subscriber<? super HttpResponseBodyPart> subscriber) {
        super.subscribe(new ErrorReplacingSubscriber(subscriber));
    }

    public boolean hasOutstandingRequest() {
        return this.hasOutstandingRequest;
    }

    NettyResponseFuture<?> future() {
        return this.future;
    }

    public void setError(Throwable t2) {
        this.error = t2;
    }

    private class ErrorReplacingSubscriber
    implements Subscriber<HttpResponseBodyPart> {
        private final Subscriber<? super HttpResponseBodyPart> subscriber;

        ErrorReplacingSubscriber(Subscriber<? super HttpResponseBodyPart> subscriber) {
            this.subscriber = subscriber;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            this.subscriber.onSubscribe(s2);
        }

        @Override
        public void onNext(HttpResponseBodyPart httpResponseBodyPart) {
            this.subscriber.onNext(httpResponseBodyPart);
        }

        @Override
        public void onError(Throwable t2) {
            this.subscriber.onError(t2);
        }

        @Override
        public void onComplete() {
            Throwable replacementError = StreamedResponsePublisher.this.error;
            if (replacementError == null) {
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(replacementError);
            }
        }
    }
}

