/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.bridge.LogEventAdapter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.SortedArrayStringMap;

public class PropertyRewritePolicy
implements RewritePolicy {
    private Map<String, String> properties = Collections.EMPTY_MAP;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(String properties) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        StringTokenizer pairs = new StringTokenizer(properties, ",");
        while (pairs.hasMoreTokens()) {
            StringTokenizer entry = new StringTokenizer(pairs.nextToken(), "=");
            newMap.put(entry.nextElement().toString().trim(), entry.nextElement().toString().trim());
        }
        PropertyRewritePolicy propertyRewritePolicy = this;
        synchronized (propertyRewritePolicy) {
            this.properties = newMap;
        }
    }

    @Override
    public LoggingEvent rewrite(LoggingEvent source2) {
        if (!this.properties.isEmpty()) {
            Log4jLogEvent event;
            HashMap<String, String> rewriteProps = source2.getProperties() != null ? new HashMap<String, String>(source2.getProperties()) : new HashMap();
            for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                if (rewriteProps.containsKey(entry.getKey())) continue;
                rewriteProps.put(entry.getKey(), entry.getValue());
            }
            if (source2 instanceof LogEventAdapter) {
                event = new Log4jLogEvent.Builder(((LogEventAdapter)source2).getEvent()).setContextData(new SortedArrayStringMap(rewriteProps)).build();
            } else {
                LocationInfo info = source2.getLocationInformation();
                StackTraceElement element = new StackTraceElement(info.getClassName(), info.getMethodName(), info.getFileName(), Integer.parseInt(info.getLineNumber()));
                Thread thread2 = this.getThread(source2.getThreadName());
                long threadId = thread2 != null ? thread2.getId() : 0L;
                int threadPriority = thread2 != null ? thread2.getPriority() : 0;
                event = Log4jLogEvent.newBuilder().setContextData(new SortedArrayStringMap(rewriteProps)).setLevel(OptionConverter.convertLevel(source2.getLevel())).setLoggerFqcn(source2.getFQNOfLoggerClass()).setMarker(null).setMessage(new SimpleMessage(source2.getRenderedMessage())).setSource(element).setLoggerName(source2.getLoggerName()).setThreadName(source2.getThreadName()).setThreadId(threadId).setThreadPriority(threadPriority).setThrown(source2.getThrowableInformation().getThrowable()).setTimeMillis(source2.getTimeStamp()).setNanoTime(0L).setThrownProxy(null).build();
            }
            return new LogEventAdapter(event);
        }
        return source2;
    }

    private Thread getThread(String name) {
        for (Thread thread2 : Thread.getAllStackTraces().keySet()) {
            if (!thread2.getName().equals(name)) continue;
            return thread2;
        }
        return null;
    }
}

