/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.rewrite;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.bridge.LogEventAdapter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.rewrite.RewritePolicy;
import org.apache.log4j.spi.LocationInfo;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.MapMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.util.SortedArrayStringMap;

public class MapRewritePolicy
implements RewritePolicy {
    @Override
    public LoggingEvent rewrite(LoggingEvent source2) {
        Object msg = source2.getMessage();
        if (msg instanceof MapMessage || msg instanceof Map) {
            Log4jLogEvent event;
            HashMap<String, String> props = source2.getProperties() != null ? new HashMap<String, String>(source2.getProperties()) : new HashMap();
            Map eventProps = msg instanceof Map ? (Map)msg : ((MapMessage)msg).getData();
            SimpleMessage newMessage = null;
            Object newMsg = eventProps.get("message");
            if (newMsg != null) {
                newMessage = new SimpleMessage(newMsg.toString());
                for (Map.Entry entry : eventProps.entrySet()) {
                    if ("message".equals(entry.getKey())) continue;
                    props.put(entry.getKey(), entry.getValue().toString());
                }
            } else {
                return source2;
            }
            if (source2 instanceof LogEventAdapter) {
                event = new Log4jLogEvent.Builder(((LogEventAdapter)source2).getEvent()).setMessage(newMessage).setContextData(new SortedArrayStringMap(props)).build();
            } else {
                LocationInfo info = source2.getLocationInformation();
                StackTraceElement element = new StackTraceElement(info.getClassName(), info.getMethodName(), info.getFileName(), Integer.parseInt(info.getLineNumber()));
                Thread thread2 = this.getThread(source2.getThreadName());
                long threadId = thread2 != null ? thread2.getId() : 0L;
                int threadPriority = thread2 != null ? thread2.getPriority() : 0;
                event = Log4jLogEvent.newBuilder().setContextData(new SortedArrayStringMap(props)).setLevel(OptionConverter.convertLevel(source2.getLevel())).setLoggerFqcn(source2.getFQNOfLoggerClass()).setMarker(null).setMessage(newMessage).setSource(element).setLoggerName(source2.getLoggerName()).setThreadName(source2.getThreadName()).setThreadId(threadId).setThreadPriority(threadPriority).setThrown(source2.getThrowableInformation().getThrowable()).setTimeMillis(source2.getTimeStamp()).setNanoTime(0L).setThrownProxy(null).build();
            }
            return new LogEventAdapter(event);
        }
        return source2;
    }

    private Thread getThread(String name) {
        for (Thread thread2 : Thread.getAllStackTraces().keySet()) {
            if (!thread2.getName().equals(name)) continue;
            return thread2;
        }
        return null;
    }
}

