/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.crypto;

import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.crypto.SignatureProvider;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;
import io.jsonwebtoken.security.InvalidKeyException;
import io.jsonwebtoken.security.SignatureException;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.interfaces.ECKey;
import java.security.spec.ECGenParameterSpec;
import java.util.HashMap;
import java.util.Map;

public abstract class EllipticCurveProvider
extends SignatureProvider {
    private static final Map<SignatureAlgorithm, String> EC_CURVE_NAMES = EllipticCurveProvider.createEcCurveNames();
    protected final int requiredSignatureByteLength;
    protected final int fieldByteLength;

    private static Map<SignatureAlgorithm, String> createEcCurveNames() {
        HashMap<SignatureAlgorithm, String> m4 = new HashMap<SignatureAlgorithm, String>();
        m4.put(SignatureAlgorithm.ES256, "secp256r1");
        m4.put(SignatureAlgorithm.ES384, "secp384r1");
        m4.put(SignatureAlgorithm.ES512, "secp521r1");
        return m4;
    }

    protected static String byteSizeString(int bytesLength) {
        return bytesLength + " bytes (" + bytesLength * 8 + " bits)";
    }

    protected EllipticCurveProvider(SignatureAlgorithm alg, Key key) {
        super(alg, key);
        Assert.isTrue(alg.isEllipticCurve(), "SignatureAlgorithm must be an Elliptic Curve algorithm.");
        if (!(key instanceof ECKey)) {
            String msg = "Elliptic Curve signatures require an ECKey. The provided key of type " + key.getClass().getName() + " is not a " + ECKey.class.getName() + " instance.";
            throw new InvalidKeyException(msg);
        }
        this.requiredSignatureByteLength = EllipticCurveProvider.getSignatureByteArrayLength(alg);
        this.fieldByteLength = this.requiredSignatureByteLength / 2;
        ECKey ecKey = (ECKey)((Object)key);
        BigInteger order = ecKey.getParams().getOrder();
        int keyFieldByteLength = (order.bitLength() + 7) / 8;
        int concatByteLength = keyFieldByteLength * 2;
        if (concatByteLength != this.requiredSignatureByteLength) {
            String msg = "EllipticCurve key has a field size of " + EllipticCurveProvider.byteSizeString(keyFieldByteLength) + ", but " + alg.name() + " requires a field size of " + EllipticCurveProvider.byteSizeString(this.fieldByteLength) + " per [RFC 7518, Section 3.4 (validation)]" + "(https://datatracker.ietf.org/doc/html/rfc7518#section-3.4).";
            throw new InvalidKeyException(msg);
        }
    }

    public static KeyPair generateKeyPair() {
        return EllipticCurveProvider.generateKeyPair(SignatureAlgorithm.ES512);
    }

    public static KeyPair generateKeyPair(SignatureAlgorithm alg) {
        return EllipticCurveProvider.generateKeyPair(alg, DEFAULT_SECURE_RANDOM);
    }

    public static KeyPair generateKeyPair(SignatureAlgorithm alg, SecureRandom random) {
        return EllipticCurveProvider.generateKeyPair("EC", null, alg, random);
    }

    public static KeyPair generateKeyPair(String jcaAlgorithmName, String jcaProviderName, SignatureAlgorithm alg, SecureRandom random) {
        Assert.notNull((Object)alg, "SignatureAlgorithm argument cannot be null.");
        Assert.isTrue(alg.isEllipticCurve(), "SignatureAlgorithm argument must represent an Elliptic Curve algorithm.");
        try {
            KeyPairGenerator g2 = Strings.hasText(jcaProviderName) ? KeyPairGenerator.getInstance(jcaAlgorithmName, jcaProviderName) : KeyPairGenerator.getInstance(jcaAlgorithmName);
            String paramSpecCurveName = EC_CURVE_NAMES.get((Object)alg);
            ECGenParameterSpec spec = new ECGenParameterSpec(paramSpecCurveName);
            g2.initialize(spec, random);
            return g2.generateKeyPair();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to generate Elliptic Curve KeyPair: " + e.getMessage(), e);
        }
    }

    public static int getSignatureByteArrayLength(SignatureAlgorithm alg) throws JwtException {
        switch (alg) {
            case ES256: {
                return 64;
            }
            case ES384: {
                return 96;
            }
            case ES512: {
                return 132;
            }
        }
        throw new JwtException("Unsupported Algorithm: " + alg.name());
    }

    public static byte[] transcodeDERToConcat(byte[] derSignature, int outputLength) throws JwtException {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (derSignature.length < 8 || derSignature[0] != 48) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        if (derSignature[1] > 0) {
            offset = 2;
        } else if (derSignature[1] == -127) {
            offset = 3;
        } else {
            throw new JwtException("Invalid ECDSA signature format");
        }
        for (i = rLength = derSignature[offset + 1]; i > 0 && derSignature[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = derSignature[offset + 2 + rLength + 1]; j > 0 && derSignature[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, outputLength / 2);
        if ((derSignature[offset - 1] & 0xFF) != derSignature.length - offset || (derSignature[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || derSignature[offset] != 2 || derSignature[offset + 2 + rLength] != 2) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        byte[] concatSignature = new byte[2 * rawLen];
        System.arraycopy(derSignature, offset + 2 + rLength - i, concatSignature, rawLen - i, i);
        System.arraycopy(derSignature, offset + 2 + rLength + 2 + sLength - j, concatSignature, 2 * rawLen - j, j);
        return concatSignature;
    }

    public static byte[] transcodeConcatToDER(byte[] jwsSignature) throws JwtException {
        try {
            return EllipticCurveProvider.concatToDER(jwsSignature);
        }
        catch (Exception e) {
            String msg = "Invalid ECDSA signature format.";
            throw new SignatureException(msg, e);
        }
    }

    private static byte[] concatToDER(byte[] jwsSignature) throws ArrayIndexOutOfBoundsException {
        int offset;
        byte[] derSignature;
        int len;
        int k;
        int rawLen;
        int i;
        for (i = rawLen = jwsSignature.length / 2; i > 0 && jwsSignature[rawLen - i] == 0; --i) {
        }
        int j = i;
        if (jwsSignature[rawLen - i] < 0) {
            ++j;
        }
        for (k = rawLen; k > 0 && jwsSignature[2 * rawLen - k] == 0; --k) {
        }
        int l = k;
        if (jwsSignature[2 * rawLen - k] < 0) {
            ++l;
        }
        if ((len = 2 + j + 2 + l) > 255) {
            throw new JwtException("Invalid ECDSA signature format");
        }
        if (len < 128) {
            derSignature = new byte[4 + j + 2 + l];
            offset = 1;
        } else {
            derSignature = new byte[5 + j + 2 + l];
            derSignature[1] = -127;
            offset = 2;
        }
        derSignature[0] = 48;
        derSignature[offset++] = (byte)len;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)j;
        System.arraycopy(jwsSignature, rawLen - i, derSignature, offset + j - i, i);
        offset += j;
        derSignature[offset++] = 2;
        derSignature[offset++] = (byte)l;
        System.arraycopy(jwsSignature, 2 * rawLen - k, derSignature, offset + l - k, k);
        return derSignature;
    }
}

