/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.impl.compression.AbstractCompressionCodec;
import io.jsonwebtoken.lang.Objects;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.InflaterOutputStream;

public class DeflateCompressionCodec
extends AbstractCompressionCodec {
    private static final String DEFLATE = "DEF";
    private static final AbstractCompressionCodec.StreamWrapper WRAPPER = new AbstractCompressionCodec.StreamWrapper(){

        @Override
        public OutputStream wrap(OutputStream out) {
            return new DeflaterOutputStream(out);
        }
    };

    @Override
    public String getAlgorithmName() {
        return DEFLATE;
    }

    @Override
    protected byte[] doCompress(byte[] payload) throws IOException {
        return this.writeAndClose(payload, WRAPPER);
    }

    @Override
    protected byte[] doDecompress(byte[] compressed) throws IOException {
        try {
            return this.readAndClose(new InflaterInputStream(new ByteArrayInputStream(compressed)));
        }
        catch (IOException e1) {
            try {
                return this.doDecompressBackCompat(compressed);
            }
            catch (IOException e2) {
                throw e1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] doDecompressBackCompat(byte[] compressed) throws IOException {
        byte[] byArray;
        InflaterOutputStream inflaterOutputStream = null;
        ByteArrayOutputStream decompressedOutputStream = null;
        try {
            decompressedOutputStream = new ByteArrayOutputStream();
            inflaterOutputStream = new InflaterOutputStream(decompressedOutputStream);
            inflaterOutputStream.write(compressed);
            inflaterOutputStream.flush();
            byArray = decompressedOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            Objects.nullSafeClose(decompressedOutputStream, inflaterOutputStream);
            throw throwable;
        }
        Objects.nullSafeClose(decompressedOutputStream, inflaterOutputStream);
        return byArray;
    }
}

