/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.gson.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.io.SerializationException;
import io.jsonwebtoken.io.Serializer;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;

public class GsonSerializer<T>
implements Serializer<T> {
    static final Gson DEFAULT_GSON = new GsonBuilder().disableHtmlEscaping().create();
    private Gson gson;

    public GsonSerializer() {
        this(DEFAULT_GSON);
    }

    public GsonSerializer(Gson gson) {
        Assert.notNull(gson, "gson cannot be null.");
        this.gson = gson;
    }

    @Override
    public byte[] serialize(T t2) throws SerializationException {
        Assert.notNull(t2, "Object to serialize cannot be null.");
        try {
            return this.writeValueAsBytes(t2);
        }
        catch (Exception e) {
            String msg = "Unable to serialize object: " + e.getMessage();
            throw new SerializationException(msg, e);
        }
    }

    protected byte[] writeValueAsBytes(T t2) {
        Object o = t2 instanceof byte[] ? Encoders.BASE64.encode((byte[])t2) : (t2 instanceof char[] ? new String((char[])t2) : t2);
        return this.gson.toJson(o).getBytes(Strings.UTF_8);
    }
}

