/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.transport.security.proxy;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProxyAuthConfiguration {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String host;
    private final Integer port;
    private final String user;
    private final String password;
    private final boolean trafficInspectionEnabled;
    private final String krb5ConfigurationPath;
    private final String jaasConfigurationPath;
    private boolean validationState = false;

    public ProxyAuthConfiguration(String host, Integer port, String user, String password, boolean trafficInspectionEnabled, String krb5ConfigurationPath, String jaasConfigurationPath) {
        this.host = host;
        this.port = port;
        this.user = user;
        this.password = password;
        this.trafficInspectionEnabled = trafficInspectionEnabled;
        String krb5ConfigPathParam = krb5ConfigurationPath;
        String jaasConfigPathParam = jaasConfigurationPath;
        if (krb5ConfigurationPath == null && this.isValidBasiAuthConfiguration()) {
            krb5ConfigPathParam = System.getProperty("anypoint.platform.proxy_kerberos_krb5_path");
        }
        this.krb5ConfigurationPath = krb5ConfigPathParam;
        if (jaasConfigurationPath == null && this.isValidBasiAuthConfiguration()) {
            jaasConfigPathParam = System.getProperty("anypoint.platform.proxy_kerberos_jaas_path");
        }
        this.jaasConfigurationPath = jaasConfigPathParam;
    }

    public boolean isValidBasiAuthConfiguration() {
        return this.host != null && this.port > 0 && this.user != null && this.password != null;
    }

    public boolean isValidKerberosAuthConfiguration() {
        if (!this.isValidBasiAuthConfiguration()) {
            LOGGER.debug("Cannot have Kerberos Auth Proxy if it doesn't have the basic auth parameters (host, port, user and password) ");
            return false;
        }
        if (StringUtils.isEmpty(this.krb5ConfigurationPath) && StringUtils.isEmpty(this.jaasConfigurationPath)) {
            return false;
        }
        this.validateFile(this.krb5ConfigurationPath);
        if (!this.validationState) {
            LOGGER.error("Invalid file path for KDC krb5.conf configuration");
        }
        this.validateFile(this.jaasConfigurationPath);
        if (!this.validationState) {
            LOGGER.error("Invalid file path for JAAS login.conf configuration");
        }
        return this.validationState;
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isTrafficInspectionEnabled() {
        return this.trafficInspectionEnabled;
    }

    public String getKrb5ConfigurationPath() {
        return this.krb5ConfigurationPath;
    }

    public String getJaasConfigurationPath() {
        return this.jaasConfigurationPath;
    }

    private void validateFile(String filePath) {
        if (StringUtils.isEmpty(filePath)) {
            this.validationState = false;
            return;
        }
        try {
            File f = new File(filePath);
            if (f.exists() && !f.isDirectory() && f.isFile()) {
                this.validationState = true;
                return;
            }
        }
        catch (SecurityException e) {
            this.validationState = true;
            return;
        }
        this.validationState = false;
    }
}

