/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.transport.security.proxy;

import com.mulesoft.transport.security.kerberos.KerberosUtils;
import com.mulesoft.transport.security.proxy.BasicProxyAuthenticator;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import com.mulesoft.transport.security.proxy.SpnegoKerberosProxyAuthenticator;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.function.Consumer;
import okhttp3.Authenticator;
import okhttp3.OkHttpClient;

public class OkHttpProxyConfigurator {
    Consumer<String> logger;

    public OkHttpProxyConfigurator(Consumer<String> logger) {
        this.logger = logger;
    }

    public OkHttpClient.Builder configure(OkHttpClient.Builder httpClientBuilder, ProxyAuthConfiguration proxyAuthConfiguration) {
        if (proxyAuthConfiguration == null || proxyAuthConfiguration.getHost() == null) {
            this.logger.accept("Configuring HTTP Client with no Proxy");
            return httpClientBuilder;
        }
        this.logger.accept(String.format("Configuring HTTP Client with Proxy, host: %s, port: %d", proxyAuthConfiguration.getHost(), proxyAuthConfiguration.getPort()));
        httpClientBuilder = httpClientBuilder.proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyAuthConfiguration.getHost(), (int)proxyAuthConfiguration.getPort())));
        if (proxyAuthConfiguration.isValidKerberosAuthConfiguration()) {
            this.logger.accept(String.format("Configuring HTTP Client with Proxy with Kerberos authentication, krb5ConfigPath: %s, jaasConfigPath: %s", proxyAuthConfiguration.getKrb5ConfigurationPath(), proxyAuthConfiguration.getJaasConfigurationPath()));
            httpClientBuilder = httpClientBuilder.proxyAuthenticator(new DefaultProxyAuthenticatorFactory().buildProxyAuthenticator(ProxyAuthType.SPNEGO, proxyAuthConfiguration));
        } else if (proxyAuthConfiguration.isValidBasiAuthConfiguration()) {
            this.logger.accept("Configuring HTTP Client with Proxy with basic authentication");
            httpClientBuilder = httpClientBuilder.proxyAuthenticator(new DefaultProxyAuthenticatorFactory().buildProxyAuthenticator(ProxyAuthType.BASIC, proxyAuthConfiguration));
        }
        return httpClientBuilder;
    }

    private static enum ProxyAuthType {
        NONE,
        BASIC,
        SPNEGO;

    }

    private class DefaultProxyAuthenticatorFactory {
        private DefaultProxyAuthenticatorFactory() {
        }

        public Authenticator buildProxyAuthenticator(ProxyAuthType proxyAuthType, ProxyAuthConfiguration proxyAuthConfiguration) {
            Authenticator proxyAuthenticator = null;
            switch (proxyAuthType) {
                case BASIC: {
                    proxyAuthenticator = new BasicProxyAuthenticator(proxyAuthConfiguration.getUser(), proxyAuthConfiguration.getPassword());
                    break;
                }
                case SPNEGO: {
                    KerberosUtils.setupKerberosAuthProperties(proxyAuthConfiguration);
                    proxyAuthenticator = new SpnegoKerberosProxyAuthenticator(proxyAuthConfiguration.getHost());
                    break;
                }
                case NONE: {
                    break;
                }
                default: {
                    throw new RuntimeException(String.format("Invalid ProxyAuthType [%s]", new Object[]{proxyAuthType}));
                }
            }
            return proxyAuthenticator;
        }
    }
}

