/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.transport.security.kerberos;

import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.security.Security;
import org.apache.commons.lang3.StringUtils;

public class KerberosUtils {
    public static void setupKerberosAuthProperties(ProxyAuthConfiguration proxyAuthConfiguration) {
        if (proxyAuthConfiguration == null) {
            throw new IllegalArgumentException("ProxyAuthConfiguration cannot be null");
        }
        if (StringUtils.isEmpty(proxyAuthConfiguration.getUser()) || StringUtils.isEmpty(proxyAuthConfiguration.getPassword())) {
            throw new IllegalArgumentException("Invalid Kerberos principal credentials: proxy user and password are required");
        }
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "false");
        if (!proxyAuthConfiguration.isValidKerberosAuthConfiguration()) {
            throw new IllegalArgumentException("Invalid Kerberos principal configuration files: file not found");
        }
        System.setProperty("java.security.krb5.conf", proxyAuthConfiguration.getKrb5ConfigurationPath().trim());
        System.setProperty("java.security.auth.login.config", "=" + proxyAuthConfiguration.getJaasConfigurationPath().trim());
        Security.setProperty("java.security.mule.agent.krb5.login.user", proxyAuthConfiguration.getUser());
        Security.setProperty("java.security.mule.agent.krb5.login.password", proxyAuthConfiguration.getPassword());
        Security.setProperty("auth.login.defaultCallbackHandler", "com.mulesoft.transport.security.kerberos.KerberosCallBackHandler");
    }
}

