/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.internal.encryption;

import javax.crypto.spec.SecretKeySpec;
import org.mule.encryption.Encrypter;
import org.mule.encryption.jce.JCEEncrypter;
import org.mule.encryption.key.SymmetricKeyFactory;

public class GatewayEncrypterBuilder {
    private String key;
    private String transformation;
    private String algorithm;

    public GatewayEncrypterBuilder key(String key) {
        this.key = key;
        return this;
    }

    public GatewayEncrypterBuilder algorithm(String algorithm) {
        this.algorithm = algorithm;
        return this;
    }

    public GatewayEncrypterBuilder transformation(String transformation) {
        this.transformation = transformation;
        return this;
    }

    public Encrypter build() {
        SymmetricKeyFactory keyFactory = () -> new SecretKeySpec(this.key.getBytes(), this.algorithm);
        return new JCEEncrypter(this.transformation, keyFactory);
    }
}

