/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.service;

import com.mulesoft.agent.services.MuleConfigurationService;
import com.mulesoft.agent.util.WrapperPropertiesUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

@Singleton
@Named(value="internal.service.muleconfiguration")
public class DefaultMuleConfigurationService
implements MuleConfigurationService {
    private static final String WRAPPER_CONF_FILE = "wrapper.conf";

    @Override
    public void addWrapperJavaAdditionalProperty(File confFolder, String name, String value) throws IOException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(name, value);
        this.addWrapperJavaAdditionalProperties(confFolder, propertyMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWrapperJavaAdditionalProperties(File confFolder, Map<String, String> propertyMap) throws IOException {
        FileInputStream propertiesStream = null;
        BufferedWriter bufferedWriter = null;
        FileWriter fileWriter = null;
        try {
            int maxIndex = 0;
            File wrapperFile = new File(confFolder, WRAPPER_CONF_FILE);
            File tempWrapperFile = File.createTempFile("wrapper-temp-file", "tmp");
            propertiesStream = new FileInputStream(wrapperFile);
            Properties properties = new Properties();
            properties.load(propertiesStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!WrapperPropertiesUtils.isWrapperAdditionalJavaPropertyTruncated((String)entry.getKey())) continue;
                int index = WrapperPropertiesUtils.getWrapperAdditionalJavaPropertyIndex((String)entry.getKey());
                maxIndex = index > maxIndex ? index : maxIndex;
            }
            ++maxIndex;
            fileWriter = new FileWriter(tempWrapperFile);
            bufferedWriter = new BufferedWriter(fileWriter);
            for (String string : FileUtils.readLines(wrapperFile)) {
                String keyToRemove = null;
                boolean ignoreLine = false;
                if (WrapperPropertiesUtils.isWrapperAdditionalJavaProperty(string)) {
                    for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                        String key = WrapperPropertiesUtils.removeDPrefixFromKey(entry.getKey());
                        int index = WrapperPropertiesUtils.getWrapperAdditionalJavaPropertyIndex(string);
                        if (!StringUtils.contains(string, String.format("%s%s=", "-D", key))) continue;
                        bufferedWriter.append(WrapperPropertiesUtils.buildProperty(index, key, entry.getValue()));
                        bufferedWriter.newLine();
                        ignoreLine = true;
                        keyToRemove = entry.getKey();
                        break;
                    }
                }
                if (keyToRemove != null) {
                    propertyMap.remove(keyToRemove);
                }
                if (ignoreLine) continue;
                bufferedWriter.append(string);
                bufferedWriter.newLine();
            }
            for (Map.Entry entry : propertyMap.entrySet()) {
                String key = WrapperPropertiesUtils.removeDPrefixFromKey((String)entry.getKey());
                bufferedWriter.append(WrapperPropertiesUtils.buildProperty(maxIndex, key, (String)entry.getValue()));
                bufferedWriter.newLine();
                ++maxIndex;
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            fileWriter.close();
            propertiesStream.close();
            Files.move(tempWrapperFile.toPath(), wrapperFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedWriter);
            IOUtils.closeQuietly(fileWriter);
            IOUtils.closeQuietly(propertiesStream);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedWriter);
        IOUtils.closeQuietly(fileWriter);
        IOUtils.closeQuietly(propertiesStream);
    }

    @Override
    public void removeWrapperJavaAdditionalProperty(File confFolder, String name, String value) throws IOException {
        HashMap<String, String> propertyMap = new HashMap<String, String>();
        propertyMap.put(name, value);
        this.removeWrapperJavaAdditionalProperties(confFolder, propertyMap);
    }

    private Map<Integer, Integer> getResequencedIndexesMap(List<String> wrapperFileLines, Map<String, String> propertyMap) {
        HashMap<Integer, Integer> propertyIndexMap = new HashMap<Integer, Integer>();
        int index = 1;
        for (String line2 : wrapperFileLines.stream().filter(line -> WrapperPropertiesUtils.isWrapperAdditionalJavaProperty(line)).collect(Collectors.toList())) {
            boolean ignoreLine = false;
            String deletedEntryKey = null;
            for (Map.Entry<String, String> entry : propertyMap.entrySet()) {
                if (!WrapperPropertiesUtils.lineContainsEntry(line2, entry)) continue;
                deletedEntryKey = entry.getKey();
                ignoreLine = true;
                break;
            }
            if (!ignoreLine) {
                propertyIndexMap.put(WrapperPropertiesUtils.getWrapperAdditionalJavaPropertyIndex(line2), index);
                ++index;
                continue;
            }
            propertyMap.remove(deletedEntryKey);
        }
        return propertyIndexMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeWrapperJavaAdditionalProperties(File confFolder, Map<String, String> propertyMap) throws IOException {
        FileWriter fileWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            File wrapperFile = new File(confFolder, WRAPPER_CONF_FILE);
            File tempWrapperFile = File.createTempFile("wrapper-temp-file", "tmp");
            fileWriter = new FileWriter(tempWrapperFile);
            bufferedWriter = new BufferedWriter(fileWriter);
            List<String> wrapperFileLines = FileUtils.readLines(wrapperFile);
            Map<Integer, Integer> propertyIndexMap = this.getResequencedIndexesMap(wrapperFileLines, propertyMap);
            for (String line : wrapperFileLines) {
                if (WrapperPropertiesUtils.isWrapperAdditionalJavaProperty(line)) {
                    if (!propertyIndexMap.containsKey(WrapperPropertiesUtils.getWrapperAdditionalJavaPropertyIndex(line))) continue;
                    bufferedWriter.append(String.format("wrapper.java.additional.%s=%s", propertyIndexMap.get(WrapperPropertiesUtils.getWrapperAdditionalJavaPropertyIndex(line)), StringUtils.substringAfter(line, "=")));
                    bufferedWriter.newLine();
                    continue;
                }
                if (WrapperPropertiesUtils.isWrapperAdditionalJavaPropertyWithSuffix(line)) {
                    bufferedWriter.append(String.format("wrapper.java.additional.%s." + WrapperPropertiesUtils.getWrapperAdditionalJavaPropertySuffix(line) + "=%s", propertyIndexMap.get(WrapperPropertiesUtils.getWrapperAdditionalJavaPropertyIndex(line)), StringUtils.substringAfter(line, "=")));
                    bufferedWriter.newLine();
                    continue;
                }
                bufferedWriter.append(line);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            fileWriter.close();
            Files.move(tempWrapperFile.toPath(), wrapperFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedWriter);
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly(bufferedWriter);
        IOUtils.closeQuietly(fileWriter);
    }

    @Override
    public boolean isPropertySet(File configurationFolder, String propertyKey, String propertyValue) {
        try {
            File wrapperFile = new File(configurationFolder, WRAPPER_CONF_FILE);
            for (String line : FileUtils.readLines(wrapperFile)) {
                if (!WrapperPropertiesUtils.isWrapperAdditionalJavaProperty(line) || !StringUtils.contains(line, String.format("%s%s=%s", "-D", propertyKey, propertyValue))) continue;
                return true;
            }
        }
        catch (Exception ex) {
            System.out.println("ERROR: " + String.format("Unable to check the value of property %s in %s file, exception %s", propertyKey, WRAPPER_CONF_FILE, ex));
        }
        return false;
    }
}

