/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.client.okhttp;

import com.mulesoft.transport.security.proxy.OkHttpProxyConfigurator;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class HTTPSUtils {
    private static final Logger LOGGER = LogManager.getLogger(HTTPSUtils.class);

    @NotNull
    public static OkHttpClient buildHttpClient(ProxyAuthConfiguration proxyAuthConfiguration) {
        return HTTPSUtils.doBuildOkHttpClient(proxyAuthConfiguration, false);
    }

    @NotNull
    public static OkHttpClient buildWsClient(ProxyAuthConfiguration proxyAuthConfiguration) {
        return HTTPSUtils.doBuildOkHttpClient(proxyAuthConfiguration, true);
    }

    @NotNull
    public static OkHttpClient configureMutualTlsInHttpClient(OkHttpClient initialHttpClient, SSLContext sslContext, TrustManagerFactory trustManagerFactory) {
        if (HTTPSUtils.isOnPrem(trustManagerFactory)) {
            return HTTPSUtils.configureMutualTlsInOnPremHttpClient(initialHttpClient, sslContext, trustManagerFactory);
        }
        return initialHttpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), initialHttpClient.x509TrustManager()).build();
    }

    @NotNull
    private static OkHttpClient configureMutualTlsInOnPremHttpClient(OkHttpClient initialHttpClient, SSLContext sslContext, TrustManagerFactory trustManagerFactory) {
        Object[] trustManagers;
        X509TrustManager trustManager = null;
        for (TrustManager trustManager2 : trustManagers = trustManagerFactory.getTrustManagers()) {
            if (!(trustManager2 instanceof X509TrustManager)) continue;
            trustManager = (X509TrustManager)trustManager2;
        }
        if (trustManager == null) {
            throw new IllegalStateException(String.format("Unexpected trust managers for default algorithm %s: %s", trustManagerFactory.getAlgorithm(), Arrays.toString(trustManagers)));
        }
        return initialHttpClient.newBuilder().sslSocketFactory(sslContext.getSocketFactory(), trustManager).hostnameVerifier((hostname, sslSession) -> true).build();
    }

    @NotNull
    private static OkHttpClient doBuildOkHttpClient(ProxyAuthConfiguration proxyAuthConfiguration, boolean isWsClient) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder();
        httpClientBuilder = new OkHttpProxyConfigurator(LOGGER::debug).configure(httpClientBuilder, proxyAuthConfiguration);
        if (isWsClient) {
            httpClientBuilder = httpClientBuilder.readTimeout(0L, TimeUnit.MILLISECONDS);
        }
        return httpClientBuilder.build();
    }

    private static boolean isOnPrem(TrustManagerFactory trustManagerFactory) {
        return trustManagerFactory != null;
    }
}

