/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.client;

import com.mulesoft.agent.configuration.common.SecurityConfiguration;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.ssl.SSLContextLoader;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Dsl;
import org.asynchttpclient.proxy.ProxyServer;

public class DefaultAuthenticationProxyUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String TLS_VERSION = "TLSv1.2";
    private static final String MINIMUM_AGENT_VERSION_USING_JVM_TRUSTSTORE = "2.2.0-SNAPSHOT";
    public static final String CONFIGURATION_FOLDER_PROPERTY = "mule.agent.configuration.folder";

    public static SSLContext createSSLContext() throws NoSuchAlgorithmException {
        return SSLContext.getInstance(TLS_VERSION);
    }

    public static SSLContextLoader initialiseSSLContext(SSLContext sslContext, EncryptionService passwordEncryptor, SecurityConfiguration securityConfiguration, String agentVersion, String environment) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException, KeyManagementException, AgentEncryptionException {
        char[] password = passwordEncryptor.decrypt(securityConfiguration.getKeyStorePassword()).toCharArray();
        SSLContextLoader sslContextLoader = new SSLContextLoader.Builder(DefaultAuthenticationProxyUtil.shouldUsePublicTruststore(agentVersion, environment), FipsUtils.getKeystoreType()).loadKeyStore(securityConfiguration.getKeyStoreFile(), password, password).loadTrustStore(securityConfiguration.getTrustStoreFile(), FipsUtils.getTrustStorePassword(password)).build();
        sslContextLoader.init(sslContext);
        if (!StringUtils.startsWithIgnoreCase(sslContext.getProtocol(), "TLS")) {
            LOGGER.warn(String.format("Potentially insecure SSL context built with protocol %s", sslContext.getProtocol()));
        }
        return sslContextLoader;
    }

    public static AsyncHttpClient buildAsyncHttpClient(SSLContext sslContext, ProxyAuthConfiguration proxyAuthConfiguration) throws URISyntaxException {
        LOGGER.debug("Building basic authenticated HTTP client.");
        DefaultAsyncHttpClientConfig.Builder builder = new DefaultAsyncHttpClientConfig.Builder().setThreadPoolName("DefaultAuthenticationProxy_AsyncHttpClient").addChannelOption(ChannelOption.ALLOCATOR, UnpooledByteBufAllocator.DEFAULT).setSslContext(new JdkSslContext(sslContext, true, ClientAuth.REQUIRE));
        if (proxyAuthConfiguration != null && (StringUtils.isBlank(proxyAuthConfiguration.getHost()) || proxyAuthConfiguration.getPort() == null)) {
            LOGGER.warn("You have a proxy configured for the Authentication Proxy but it doesn't have the host and port configured.");
        }
        if (proxyAuthConfiguration != null && StringUtils.isNotBlank(proxyAuthConfiguration.getHost()) && proxyAuthConfiguration.getPort() != null) {
            ProxyServer proxyServer;
            URI uri = new URI(proxyAuthConfiguration.getHost());
            String host = uri.getHost();
            String scheme = uri.getScheme();
            if (scheme == null) {
                LOGGER.debug(String.format("Using proxy configuration for communication with the Authentication Proxy at %s:%s.", host, proxyAuthConfiguration.getPort()));
                host = proxyAuthConfiguration.getHost();
            } else {
                LOGGER.debug(String.format("Using proxy configuration for communication with the Authentication Proxy at %s://%s:%s.", scheme, host, proxyAuthConfiguration.getPort()));
            }
            if (proxyAuthConfiguration.getUser() != null && proxyAuthConfiguration.getPassword() != null) {
                String user = proxyAuthConfiguration.getUser();
                LOGGER.debug(String.format("Proxy server authentication for the Authentication Proxy is enabled using user %s", user));
                proxyServer = new ProxyServer.Builder(host, proxyAuthConfiguration.getPort()).setRealm(Dsl.basicAuthRealm(user, proxyAuthConfiguration.getPassword()).build()).build();
            } else {
                proxyServer = new ProxyServer.Builder(host, proxyAuthConfiguration.getPort()).build();
            }
            builder = builder.setProxyServer(proxyServer);
        } else {
            LOGGER.warn("Proxy configuration for the Authentication Proxy with basic auth client is either null or missing host/port fields. Resorting to default, non-proxied client");
        }
        LOGGER.warn("Could not resolve proxy configuration for the Authentication Proxy. Falling back to default client instance");
        return new DefaultAsyncHttpClient(builder.build());
    }

    protected static boolean shouldUsePublicTruststore(String agentVersion, String environment) {
        if (environment != null && environment.equals(RuntimeEnvironment.ON_PREM.getValue())) {
            return false;
        }
        ComparableVersion minimumVersionMule4 = new ComparableVersion(MINIMUM_AGENT_VERSION_USING_JVM_TRUSTSTORE);
        return agentVersion == null || minimumVersionMule4.compareTo(new ComparableVersion(agentVersion)) < 0;
    }
}

