/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.clients.AuthenticationProxyFactory;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.common.AuthenticationProxyConfiguration;
import com.mulesoft.agent.configuration.encryption.EncryptionServiceBuilder;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.ssl.SSLContextLoader;
import com.mulesoft.agent.util.ProxyConfigurationHelper;
import com.mulesoft.agent.util.client.AuthenticationProxyFactoryStrategy;
import com.mulesoft.agent.util.client.DefaultAuthenticationProxyUtil;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.net.ssl.SSLContext;

@Singleton
@Named(value="internal.factory.authentication-proxy")
public class DefaultAuthenticationProxyFactory
implements AuthenticationProxyFactory {
    @Configurable
    private String environment;

    @Override
    public AuthenticationProxyClient create(AuthenticationProxyConfiguration configuration, ObjectMapper objectMapper) {
        return this.create(configuration, objectMapper, null);
    }

    @Override
    public AuthenticationProxyClient create(AuthenticationProxyConfiguration configuration, ObjectMapper objectMapper, String previousInstalledAgentVersion) {
        try {
            AuthenticationProxyFactoryStrategy creationStrategy = AuthenticationProxyFactoryStrategy.CLIENT_ASYNCHTTP;
            ProxyAuthConfiguration proxyAuthConfiguration = ProxyConfigurationHelper.createProxyAuthConfiguration(configuration.getProxyConfiguration(), configuration.getProxyKerberosConfiguration());
            if (proxyAuthConfiguration.isValidKerberosAuthConfiguration()) {
                creationStrategy = AuthenticationProxyFactoryStrategy.CLIENT_OKHTTP;
            }
            EncryptionService encryptorService = EncryptionServiceBuilder.newInstance().build();
            SSLContext sslContext = DefaultAuthenticationProxyUtil.createSSLContext();
            SSLContextLoader sslContextLoader = DefaultAuthenticationProxyUtil.initialiseSSLContext(sslContext, encryptorService, configuration.getSecurity(), previousInstalledAgentVersion, this.environment);
            return creationStrategy.create(configuration.getEndpoint(), proxyAuthConfiguration, sslContext, sslContextLoader, objectMapper);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

