/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.details.utils.DefaultCertificateDetails;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.util.TrafficInspectionUtil;
import com.mulesoft.agent.util.client.URIUtils;
import com.mulesoft.transport.security.proxy.ProxyAuthConfiguration;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;

public final class DefaultAuthenticationProxyClient
implements AuthenticationProxyClient {
    private static final Logger LOGGER = LogManager.getLogger(DefaultAuthenticationProxyClient.class);
    private final URI baseUrl;
    private final AsyncHttpClient client;
    private final ObjectMapper objectMapper;
    private final ProxyAuthConfiguration proxyAuthConfiguration;
    private DefaultCertificateDetails certificateDetails;
    private static final String BEARER_TOKEN_PREFIX = "Bearer";
    private static final String AUTHORIZATION_HEADER = "Authorization";

    DefaultAuthenticationProxyClient(URI baseUrl, AsyncHttpClient client, ObjectMapper objectMapper, ProxyAuthConfiguration proxyAuthConfiguration) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.objectMapper = objectMapper;
        this.proxyAuthConfiguration = proxyAuthConfiguration;
        this.certificateDetails = new DefaultCertificateDetails(FipsUtils.getKeystoreType());
    }

    @Override
    public <T> Response post(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            this.appendAuthHeaders(headers);
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePost(URIUtils.concatenateBaseUrlAndPath(this.baseUrl, path)).setBody(this.objectMapper.writeValueAsBytes(body))).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).execute().get();
        }
        catch (IOException e) {
            LOGGER.warn("There was an error sending post request to the auth proxy.");
            LOGGER.debug("There was an error sending post request to the auth proxy.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("There was an error retrieving the response from a post request to the auth proxy.");
            LOGGER.debug("There was an error retrieving the response from a post request to the auth proxy.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            LOGGER.warn("There was an error executing a post request to the auth proxy.");
            LOGGER.debug("There was an error executing a post request to the auth proxy.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response post(String path, T body) {
        return this.post(path, body, new HashMap<CharSequence, Collection<String>>(0));
    }

    @Override
    public <T> Response put(String path, T body, Map<CharSequence, Collection<String>> headers) {
        try {
            this.appendAuthHeaders(headers);
            return (Response)((BoundRequestBuilder)((BoundRequestBuilder)((BoundRequestBuilder)this.client.preparePut(URIUtils.concatenateBaseUrlAndPath(this.baseUrl, path)).setBody(this.objectMapper.writeValueAsBytes(body))).setHeaders(headers)).setHeader((CharSequence)"Content-Type", "application/json")).execute().get();
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("There was an error serializing the request body.");
            LOGGER.debug("There was an error serializing the request body.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            LOGGER.warn("There was an error retrieving the response from a put request to the auth proxy.");
            LOGGER.debug("There was an error retrieving the response from a put request to the auth proxy.", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            LOGGER.warn("There was an error executing a put request to the auth proxy.");
            LOGGER.debug("There was an error executing a put request to the auth proxy.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> Response put(String path, T body) {
        return this.put(path, body, new HashMap<CharSequence, Collection<String>>(0));
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            LOGGER.warn("The connection could not be closed.");
            LOGGER.debug("The connection could not be closed.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void appendAuthHeaders(Map<CharSequence, Collection<String>> headers) {
        if (this.proxyAuthConfiguration.isTrafficInspectionEnabled()) {
            String jwt = TrafficInspectionUtil.generateAndSignJWT(this.certificateDetails.getPrivateKey(), this.certificateDetails.getCertChain(), this.certificateDetails.getServerId());
            String bearerToken = String.format("%s %s", BEARER_TOKEN_PREFIX, jwt);
            headers.put(AUTHORIZATION_HEADER, Lists.newArrayList(bearerToken));
        }
    }
}

