/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util;

import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrafficInspectionUtil {
    private static final Logger LOGGER = LogManager.getLogger(TrafficInspectionUtil.class);

    public static String generateAndSignJWT(Key privateKey, Certificate[] certificateChain, String muleServerId) {
        ArrayList<String> x5cList = new ArrayList<String>();
        try {
            for (Certificate certificate : certificateChain) {
                X509Certificate X509cert = (X509Certificate)certificate;
                String encodedCert = Base64.getEncoder().encodeToString(X509cert.getEncoded());
                x5cList.add(encodedCert);
            }
        }
        catch (CertificateEncodingException e) {
            LOGGER.error("Error during the B64 encoding of client certificate", (Throwable)e);
        }
        String jwt = Jwts.builder().setSubject(muleServerId).setIssuer("mule-agent").setIssuedAt(new Date(System.currentTimeMillis())).setExpiration(new Date(System.currentTimeMillis() + 300000L)).setNotBefore(new Date(System.currentTimeMillis() - 180000L)).claim("x5c", x5cList).signWith(privateKey).compact();
        return jwt;
    }
}

