/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util;

import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Named;

public class IOCUtils {
    public static String getName(Class type) {
        for (Class searchClass = type; searchClass != Object.class; searchClass = searchClass.getSuperclass()) {
            Named name = type.getAnnotation(Named.class);
            if (name == null) continue;
            return name.value();
        }
        throw new IllegalArgumentException(String.format("Class '%s' is not annotated with @%s", type.getName(), Named.class));
    }

    public static Annotation getNamedAnnotation(Class type) {
        return Names.named(IOCUtils.getName(type));
    }

    public static <T> Map<String, T> toNamedMap(Collection<T> objects) {
        return objects.stream().collect(Collectors.toMap(o -> IOCUtils.getName(o.getClass()), Function.identity()));
    }
}

