/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.util;

import com.mulesoft.agent.services.LicenseService;
import com.mulesoft.mule.runtime.core.api.license.MuleLicense;
import com.mulesoft.mule.runtime.core.api.license.MuleLicenseUtils;
import com.mulesoft.mule.runtime.core.api.license.NoValidLicenseFoundException;
import java.util.Date;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="internal.service.license")
@Singleton
public class DefaultLicenseService
implements LicenseService {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public boolean hasValidLicense() {
        try {
            MuleLicense license = MuleLicenseUtils.getLicense();
            if (license.isEvaluation()) {
                LOGGER.info("Mule EE evaluation version. Enabling Mule Agent usage.");
            } else {
                LOGGER.info("Mule EE version. Enabling Mule Agent usage.");
            }
            return true;
        }
        catch (NoValidLicenseFoundException e) {
            LOGGER.info("Mule version is not valid, it must be EE or EE evaluation. Can't enable Mule Agent usage.");
            LOGGER.debug(e);
            return false;
        }
    }

    @Override
    public Date getExpirationDate() {
        Date muleLicenseExpirationDate = null;
        try {
            muleLicenseExpirationDate = MuleLicenseUtils.getLicense().getExpirationDate();
        }
        catch (NoValidLicenseFoundException e) {
            LOGGER.warn("Could not get mule license expiration date.", (Throwable)e);
        }
        return muleLicenseExpirationDate;
    }

    @Override
    public boolean hasEntitlement(String entitlement) {
        try {
            MuleLicense license = MuleLicenseUtils.getLicense();
            return license.isEvaluation() || license.hasEntitlement(entitlement, "");
        }
        catch (NoValidLicenseFoundException e) {
            LOGGER.debug(e);
            return false;
        }
    }
}

