/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ssl;

import com.mulesoft.agent.security.model.KeystoreType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextLoader {
    private final KeyManagerFactory kmf;
    private final TrustManagerFactory tmf;

    private SSLContextLoader(KeyManagerFactory kmf, TrustManagerFactory tmf) {
        this.kmf = kmf;
        this.tmf = tmf;
    }

    public void init(SSLContext sslContext) throws KeyManagementException {
        KeyManager[] keyManagers = this.kmf.getKeyManagers();
        SecureRandom secureRandom = new SecureRandom();
        TrustManager[] trustManagers = null;
        if (this.tmf != null) {
            trustManagers = this.tmf.getTrustManagers();
        }
        sslContext.init(keyManagers, trustManagers, secureRandom);
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.tmf;
    }

    public static class Builder {
        private boolean publicTrustStore;
        private KeyManagerFactory kmf;
        private KeyStore keyStore;
        private TrustManagerFactory tmf;
        private String keystoreType;

        public Builder(boolean publicTrustStore, String keystoreType) {
            this.publicTrustStore = publicTrustStore;
            this.keystoreType = keystoreType;
        }

        public Builder loadKeyStore(String filename, char[] password, char[] keyPassword) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException, UnrecoverableKeyException {
            block2: {
                File keyStoreFile = new File(filename);
                try {
                    this.keyStore = KeyStore.getInstance(this.keystoreType);
                    this.keyStore.load(new FileInputStream(keyStoreFile), password);
                }
                catch (Exception e) {
                    if (!this.keystoreType.equalsIgnoreCase(KeystoreType.FIPS.toString())) break block2;
                    this.keyStore = KeyStore.getInstance(KeystoreType.PKCS12.toString());
                    this.keyStore.load(new FileInputStream(keyStoreFile), password);
                }
            }
            this.kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            this.kmf.init(this.keyStore, keyPassword);
            return this;
        }

        public Builder loadTrustStore(String filename, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
            if (this.publicTrustStore) {
                this.tmf = null;
            } else {
                KeyStore trustStore;
                block4: {
                    trustStore = null;
                    try {
                        trustStore = KeyStore.getInstance(this.keystoreType);
                        trustStore.load(new FileInputStream(new File(filename)), password);
                    }
                    catch (Exception e) {
                        if (!this.keystoreType.equalsIgnoreCase(KeystoreType.FIPS.toString())) break block4;
                        trustStore = KeyStore.getInstance(KeystoreType.PKCS12.toString());
                        trustStore.load(new FileInputStream(new File(filename)), password);
                    }
                }
                TrustManagerFactory factory2 = TrustManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                factory2.init(trustStore);
                this.tmf = factory2;
            }
            return this;
        }

        public SSLContextLoader build() {
            return new SSLContextLoader(this.kmf, this.tmf);
        }
    }
}

