/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security.strategies;

import com.mulesoft.agent.security.model.AgentSecurityModel;
import com.mulesoft.agent.security.model.AgentSecurityProvider;
import com.mulesoft.agent.security.model.KeystoreType;
import com.mulesoft.agent.security.strategies.AgentCryptographyStrategy;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class FipsCryptographyStrategy
extends AgentCryptographyStrategy {
    private static final String FIPS_APPROVE_ONLY_MODE = "org.bouncycastle.fips.approved_only";
    private static final Logger LOGGER = LogManager.getLogger(FipsCryptographyStrategy.class);

    private FipsCryptographyStrategy() {
    }

    public static FipsCryptographyStrategy newInstance() {
        return new FipsCryptographyStrategy();
    }

    @Override
    public AgentSecurityProvider getProvider() {
        return AgentSecurityProvider.BCFIPS;
    }

    @Override
    public KeystoreType getKeystoreType() {
        String securityConfigKeystoreType = Security.getProperty("keystore.type");
        if (securityConfigKeystoreType.equals(KeystoreType.FIPS.toString())) {
            LOGGER.info("FipsCryptographyStrategy uses keystore.type=FIPS");
            return KeystoreType.FIPS;
        }
        LOGGER.info("FipsCryptographyStrategy uses keystore.type=PKCS12 because the agent is in FIPS mode, but java.security keystore.type is not set to FIPS, so it defaults to PKCS12.");
        return KeystoreType.PKCS12;
    }

    @Override
    public KeyPair generateKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException {
        LOGGER.debug("Renew certificate - Generating Key Pair with FIPS Strategy");
        KeyPairGenerator keyPair = KeyPairGenerator.getInstance(this.getKeyGenerationAlgorithm().name(), this.getProvider().name());
        LOGGER.debug("Renew certificate - Generating Key Pair with FIPS - Got instance ");
        keyPair.initialize(this.getKeySize(), new SecureRandom());
        LOGGER.debug("Renew certificate - Generating Key Pair with FIPS - KeyGen initialization");
        return keyPair.generateKeyPair();
    }

    @Override
    public ContentSigner buildContentSigner(PrivateKey privateKey) throws OperatorCreationException {
        return new JcaContentSignerBuilder(this.getSignatureAlgorithm()).setProvider(this.getProvider().name()).build(privateKey);
    }

    @Override
    public void initialize() {
        System.setProperty("mule.security.model", this.getSecurityModel().value());
        System.setProperty(FIPS_APPROVE_ONLY_MODE, "false");
    }

    @Override
    public void loadSecurityProvider() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.addFipsProvider();
    }

    @Override
    public CertificateFactory getCertificateFactoryInstance() throws CertificateException, NoSuchProviderException {
        return CertificateFactory.getInstance(this.getPublicKeyFormat(), this.getProvider().name());
    }

    @Override
    public AgentSecurityModel getSecurityModel() {
        return AgentSecurityModel.FIPS140_2;
    }

    private void addFipsProvider() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Provider fipsProvider = Security.getProvider(AgentSecurityProvider.BCFIPS.name());
        if (fipsProvider == null) {
            Class<?> fipsProviderClass = FipsCryptographyStrategy.class.getClassLoader().loadClass("org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider");
            Security.addProvider((Provider)fipsProviderClass.newInstance());
        }
    }
}

