/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security.strategies;

import com.mulesoft.agent.security.model.CertificateType;
import com.mulesoft.agent.security.model.CryptographyAlgorithm;
import com.mulesoft.agent.security.strategies.CryptographyStrategy;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PublicKey;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public abstract class AgentCryptographyStrategy
implements CryptographyStrategy {
    public static final String CN = "mule";
    public static final String OU = "AGENT_ESB";
    public static final String O = "MULESOFT";
    public static final String L = "SAN FRANCISCO";
    public static final String S = "CALIFORNIA";
    public static final String C = "USA";
    private static final String DISTINGUISHED_NAME_FORMAT = "CN=%s, OU=%s, O=%s, L=%s, ST=%s, C=%s";
    private static final int KEY_SIZE = 2048;
    private String signatureAlgorithm = "SHA256withRSA";
    private String publicKeyFormat = "X.509";

    protected X500Principal buildAgentPrincipal() {
        return new X500Principal(String.format(DISTINGUISHED_NAME_FORMAT, CN, OU, O, L, S, C));
    }

    @Override
    public int getKeySize() {
        return 2048;
    }

    @Override
    public CertificateType getCertificateType() {
        return CertificateType.X509;
    }

    protected CryptographyAlgorithm getKeyGenerationAlgorithm() {
        return CryptographyAlgorithm.RSA;
    }

    protected String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public PKCS10CertificationRequest buildAgentCertificateSigningRequest(PublicKey publicKey, ContentSigner contentSigner) {
        return new JcaPKCS10CertificationRequestBuilder(this.buildAgentPrincipal(), publicKey).build(contentSigner);
    }

    @Override
    public String buildAgentCertificateSigningRequestAsString(PublicKey publicKey, ContentSigner contentSigner) throws IOException {
        return this.toPem(this.buildAgentCertificateSigningRequest(publicKey, contentSigner));
    }

    /*
     * Exception decompiling
     */
    private String toPem(Object object) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public KeyStore getKeystoreInstance() throws KeyStoreException {
        return KeyStore.getInstance(this.getKeystoreType().name());
    }

    @Override
    public String getPublicKeyFormat() {
        return this.publicKeyFormat;
    }
}

