/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import com.mulesoft.agent.security.CSRGenerator;
import com.mulesoft.agent.security.CertificateAuthority;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class KeyStoreGenerator {
    public static final int KEYSIZE = 2048;
    private KeyStore caKeyStore;
    private String caAlias;
    private char[] caKeyPassword;
    private String keystorePassword;
    private String cn;
    private String ou;
    private String o;
    private String l;
    private String s;
    private String c;
    private String alias;
    private char[] keyPassword;

    public KeyStoreGenerator(KeyStore consoleKeystore) {
        this.caKeyStore = consoleKeystore;
    }

    public KeyStore generate() throws Exception {
        Security.addProvider(new BouncyCastleProvider());
        char[] password = this.keystorePassword.toCharArray();
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
        keyGen.initialize(2048, new SecureRandom());
        KeyPair keyPair = keyGen.generateKeyPair();
        X500Principal principal = ((X509Certificate)this.caKeyStore.getCertificate(this.caAlias)).getIssuerX500Principal();
        Certificate sign = new CertificateAuthority((PrivateKey)this.caKeyStore.getKey(this.caAlias, this.caKeyPassword), principal).sign(new CSRGenerator(keyPair).generatePKCS10(this.cn, this.ou, this.o, this.l, this.s, this.c));
        KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, password);
        Certificate[] certChain = new Certificate[]{sign, this.caKeyStore.getCertificate(this.caAlias)};
        keyStore.setKeyEntry(this.alias, keyPair.getPrivate(), this.keyPassword, certChain);
        return keyStore;
    }

    public static void main(String[] args2) throws Exception {
        KeyStore store;
        String caKeyStoreTypeParam;
        if (args2 == null) {
            KeyStoreGenerator.showUsage();
        }
        Map<String, String> argsMap = KeyStoreGenerator.load(args2);
        String caKeyStoreParam = argsMap.get("caKeyStore");
        String string = caKeyStoreTypeParam = argsMap.get("caKeyStoreType") == null ? "JKS" : argsMap.get("caKeyStoreType");
        if (caKeyStoreParam == null) {
            KeyStoreGenerator.showUsage();
        }
        try (FileInputStream keystore = new FileInputStream(new File(caKeyStoreParam));){
            store = KeyStore.getInstance(caKeyStoreTypeParam);
            store.load(keystore, KeyStoreGenerator.readConsole("CA keystore keystorePassword:").toCharArray());
        }
        KeyStoreGenerator keyStoreGenerator = new KeyStoreGenerator(store);
        keyStoreGenerator.caAlias = KeyStoreGenerator.readConsole("CA alias:");
        keyStoreGenerator.caKeyPassword = KeyStoreGenerator.readConsole("CA alias keystorePassword:").toCharArray();
        keyStoreGenerator.keystorePassword = KeyStoreGenerator.readConsole("Your keystore password:");
        keyStoreGenerator.alias = KeyStoreGenerator.readConsole("Your key alias:");
        keyStoreGenerator.keyPassword = KeyStoreGenerator.readConsole("Your key password:").toCharArray();
        keyStoreGenerator.cn = KeyStoreGenerator.readConsole("CN:");
        keyStoreGenerator.o = KeyStoreGenerator.readConsole("O:");
        keyStoreGenerator.ou = KeyStoreGenerator.readConsole("OU:");
        keyStoreGenerator.l = KeyStoreGenerator.readConsole("L:");
        keyStoreGenerator.s = KeyStoreGenerator.readConsole("S:");
        keyStoreGenerator.c = KeyStoreGenerator.readConsole("C:");
        KeyStore generatedKeystore = keyStoreGenerator.generate();
        try (FileOutputStream fos = new FileOutputStream("mule-agent.jks");){
            generatedKeystore.store(fos, keyStoreGenerator.keystorePassword.toCharArray());
        }
    }

    private static void showUsage() {
        System.err.println("Parameters:");
        System.err.println("\t\t-caKeyStore -- location of the CA Key Store");
        System.err.println("\t\t-caKeyStoreType -- type of the CA Key Store (Optional, Default is JKS");
        System.exit(1);
    }

    public static String readConsole(String message) {
        System.out.print(message);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            String value = br.readLine();
            return value;
        }
        catch (IOException ioe) {
            System.out.println("IO error trying to read your name!");
            System.exit(1);
            return null;
        }
    }

    private static Map<String, String> load(String[] args2) {
        HashMap<String, String> argsMap = new HashMap<String, String>();
        for (int i = 0; i < args2.length; ++i) {
            if (!args2[i].startsWith("-") || i + 1 >= args2.length) continue;
            argsMap.put(args2[i].substring(1), args2[i + 1]);
            ++i;
        }
        return argsMap;
    }

    public String getCaAlias() {
        return this.caAlias;
    }

    public void setCaAlias(String caAlias) {
        this.caAlias = caAlias;
    }

    public char[] getCaKeyPassword() {
        return this.caKeyPassword;
    }

    public void setCaKeyPassword(char[] caKeyPassword) {
        this.caKeyPassword = caKeyPassword;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getCn() {
        return this.cn;
    }

    public void setCn(String cn) {
        this.cn = cn;
    }

    public String getOU() {
        return this.ou;
    }

    public void setOU(String ou) {
        this.ou = ou;
    }

    public String getO() {
        return this.o;
    }

    public void setO(String o) {
        this.o = o;
    }

    public String getL() {
        return this.l;
    }

    public void setL(String l) {
        this.l = l;
    }

    public String getS() {
        return this.s;
    }

    public void setS(String s2) {
        this.s = s2;
    }

    public String getC() {
        return this.c;
    }

    public void setC(String c) {
        this.c = c;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public char[] getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(char[] keyPassword) {
        this.keyPassword = keyPassword;
    }
}

