/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import com.mulesoft.agent.security.AgentSecurityManagerBuilder;

public class FipsUtils {
    private static final String NON_FIPS_KEYSTORE_TYPE = "JKS";

    public static String getProvider() {
        return AgentSecurityManagerBuilder.newInstance().useFipsConfigurationProperty().build().getCryptographyStrategy().getProvider().name();
    }

    public static boolean isFipsEnabled() {
        return AgentSecurityManagerBuilder.newInstance().useFipsConfigurationProperty().build().isFipsEnabled();
    }

    public static String getKeystoreType() {
        return AgentSecurityManagerBuilder.newInstance().useFipsConfigurationProperty().build().getCryptographyStrategy().getKeystoreType().name();
    }

    public static char[] getTrustStorePassword(char[] password) {
        return FipsUtils.getTrustStorePassword(FipsUtils.getKeystoreType(), password);
    }

    public static char[] getTrustStorePassword(String keystore, char[] password) {
        return NON_FIPS_KEYSTORE_TYPE.equalsIgnoreCase(keystore) ? null : password;
    }

    public static String getTrustStorePassword(String password) {
        if (password == null) {
            return null;
        }
        char[] pass = password.toCharArray();
        char[] trustStorePass = FipsUtils.getTrustStorePassword(FipsUtils.getKeystoreType(), pass);
        return trustStorePass != null ? String.valueOf(pass) : null;
    }
}

