/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import com.mulesoft.agent.security.AgentSecurityManager;
import com.mulesoft.agent.security.model.CryptographyAlgorithm;
import com.mulesoft.agent.security.model.KeyPairWrapper;
import com.mulesoft.agent.security.strategies.CryptographyStrategy;
import com.mulesoft.agent.security.strategies.CryptographyStrategyBuilder;
import com.mulesoft.agent.security.strategies.FipsCryptographyStrategy;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public class DefaultAgentSecurityManager
implements AgentSecurityManager {
    private static final String REMOVE_FROM_PEM = " REQUEST";
    private CryptographyAlgorithm cryptographyAlgorithm;
    private CryptographyStrategy cryptographyStrategy;

    private DefaultAgentSecurityManager(boolean isFipsEnabled) {
        this.cryptographyStrategy = CryptographyStrategyBuilder.newInstance(isFipsEnabled).build();
        this.cryptographyAlgorithm = CryptographyAlgorithm.RSA;
    }

    private DefaultAgentSecurityManager(CryptographyStrategyBuilder cryptographyStrategyBuilder) {
        this.cryptographyStrategy = cryptographyStrategyBuilder.build();
        this.cryptographyAlgorithm = CryptographyAlgorithm.RSA;
    }

    protected static DefaultAgentSecurityManager newInstance(CryptographyStrategyBuilder cryptographyStrategyBuilder) {
        return new DefaultAgentSecurityManager(cryptographyStrategyBuilder);
    }

    public static DefaultAgentSecurityManager newInstance(boolean isFipsEnabled) {
        return new DefaultAgentSecurityManager(isFipsEnabled);
    }

    public static DefaultAgentSecurityManager newInstance() {
        return DefaultAgentSecurityManager.newInstance(false);
    }

    @Override
    public boolean isFipsEnabled() {
        return this.cryptographyStrategy instanceof FipsCryptographyStrategy;
    }

    @Override
    public void initialize() throws InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchAlgorithmException {
        this.cryptographyStrategy.initialize();
        this.cryptographyStrategy.loadSecurityProvider();
    }

    @Override
    public CryptographyAlgorithm getCryptographyAlgorithm() {
        return this.cryptographyAlgorithm;
    }

    @Override
    public CryptographyStrategy getCryptographyStrategy() {
        return this.cryptographyStrategy;
    }

    @Override
    public PKCS10CertificationRequest generateAgentCertificateSigningRequest(KeyPairWrapper keyPairWrapper) throws OperatorCreationException, IOException {
        ContentSigner contentSigner = this.cryptographyStrategy.buildContentSigner(keyPairWrapper.getPrivateKey());
        return this.cryptographyStrategy.buildAgentCertificateSigningRequest(keyPairWrapper.getPublicKey(), contentSigner);
    }

    @Override
    public String generateKeystorePassword() {
        return UUID.randomUUID().toString();
    }

    @Override
    public KeyPairWrapper generateKeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator keyPair = KeyPairGenerator.getInstance(this.getCryptographyAlgorithm().name());
        keyPair.initialize(new RSAKeyGenParameterSpec(this.cryptographyStrategy.getKeySize(), RSAKeyGenParameterSpec.F4));
        return KeyPairWrapper.newInstance(keyPair.generateKeyPair());
    }

    @Override
    public InputStream transformCSRtoCertificate(InputStream certificateSigningRequest) throws IOException {
        if (certificateSigningRequest == null) {
            return null;
        }
        String certificateAsString = IOUtils.toString(certificateSigningRequest, StandardCharsets.UTF_8);
        return this.transformCSRtoCertificate(certificateAsString);
    }

    @Override
    public InputStream transformCSRtoCertificate(String certificateSigningRequest) {
        if (certificateSigningRequest == null) {
            return null;
        }
        certificateSigningRequest = certificateSigningRequest.replaceAll(REMOVE_FROM_PEM, "");
        return new ByteArrayInputStream(certificateSigningRequest.getBytes(StandardCharsets.UTF_8));
    }
}

