/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.security;

import com.mulesoft.agent.security.AgentSecurityManager;
import com.mulesoft.agent.security.DefaultAgentSecurityManager;
import com.mulesoft.agent.security.providers.FipsConfigurationProvider;
import com.mulesoft.agent.security.providers.PropertyFipsConfigurationProvider;

public class AgentSecurityManagerBuilder {
    private FipsConfigurationProvider fipsConfigurationProvider;
    private boolean fipsEnabled;

    public static AgentSecurityManagerBuilder newInstance() {
        return new AgentSecurityManagerBuilder();
    }

    public AgentSecurityManagerBuilder useFipsConfigurationProperty() {
        this.fipsConfigurationProvider = new PropertyFipsConfigurationProvider();
        return this;
    }

    public AgentSecurityManagerBuilder enableFips(boolean enable) {
        this.fipsEnabled = enable;
        return this;
    }

    public AgentSecurityManager build() {
        if (this.fipsConfigurationProvider == null) {
            return DefaultAgentSecurityManager.newInstance(this.fipsEnabled);
        }
        return DefaultAgentSecurityManager.newInstance(this.fipsConfigurationProvider.isFipsEnabled());
    }

    protected FipsConfigurationProvider getFipsConfigurationProvider() {
        return this.fipsConfigurationProvider;
    }

    protected boolean isFipsEnabled() {
        return this.fipsEnabled;
    }
}

